/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.performance.categorization;

import gov.sandia.cognition.learning.data.TargetEstimatePair;
import gov.sandia.cognition.learning.performance.categorization.AbstractConfusionMatrix;
import gov.sandia.cognition.learning.performance.categorization.ConfusionMatrix;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.Pair;
import gov.sandia.cognition.util.Summarizer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DefaultConfusionMatrix<CategoryType>
extends AbstractConfusionMatrix<CategoryType> {
    protected Map<CategoryType, Map<CategoryType, Entry>> confusions = new LinkedHashMap<CategoryType, Map<CategoryType, Entry>>();

    public DefaultConfusionMatrix() {
    }

    public DefaultConfusionMatrix(ConfusionMatrix<? extends CategoryType> other) {
        this();
        this.addAll(other);
    }

    @Override
    public DefaultConfusionMatrix<CategoryType> clone() {
        DefaultConfusionMatrix clone = (DefaultConfusionMatrix)super.clone();
        if (this.confusions != null) {
            clone.confusions = new LinkedHashMap<CategoryType, Map<CategoryType, Entry>>(this.confusions.size());
            for (Map.Entry<CategoryType, Map<CategoryType, Entry>> outerEntry : this.confusions.entrySet()) {
                LinkedHashMap<CategoryType, Entry> categoryMap = new LinkedHashMap<CategoryType, Entry>(outerEntry.getValue().size());
                clone.confusions.put(outerEntry.getKey(), categoryMap);
                for (Map.Entry<CategoryType, Entry> innerEntry : outerEntry.getValue().entrySet()) {
                    categoryMap.put(innerEntry.getKey(), innerEntry.getValue().clone());
                }
            }
        }
        return clone;
    }

    @Override
    public void add(CategoryType target, CategoryType estimate, double value) {
        Entry entry;
        Map<CategoryType, Entry> subMap = this.confusions.get(target);
        if (subMap == null) {
            subMap = new HashMap<CategoryType, Entry>();
            this.confusions.put(target, subMap);
        }
        if ((entry = subMap.get(estimate)) == null) {
            entry = new Entry(value);
            subMap.put(estimate, entry);
        } else {
            entry.increment(value);
        }
    }

    @Override
    public double getCount(CategoryType target, CategoryType estimate) {
        Map<CategoryType, Entry> subMap = this.confusions.get(target);
        if (subMap == null) {
            return 0.0;
        }
        Entry entry = subMap.get(estimate);
        if (entry == null) {
            return 0.0;
        }
        return entry.getValue();
    }

    @Override
    public double getActualCount(CategoryType target) {
        Map<CategoryType, Entry> subMap = this.confusions.get(target);
        if (subMap == null) {
            return 0.0;
        }
        double result = 0.0;
        for (Entry value : subMap.values()) {
            result += value.getValue();
        }
        return result;
    }

    @Override
    public void clear() {
        this.confusions.clear();
    }

    @Override
    public Set<CategoryType> getCategories() {
        LinkedHashSet<CategoryType> result = new LinkedHashSet<CategoryType>();
        result.addAll(this.getActualCategories());
        result.addAll(this.getPredictedCategories());
        return result;
    }

    @Override
    public Set<CategoryType> getActualCategories() {
        return this.confusions.keySet();
    }

    @Override
    public Set<CategoryType> getPredictedCategories() {
        LinkedHashSet<CategoryType> estimates = new LinkedHashSet<CategoryType>(this.confusions.size());
        for (Map<CategoryType, Entry> estimateCounts : this.confusions.values()) {
            estimates.addAll(estimateCounts.keySet());
        }
        return estimates;
    }

    @Override
    public Set<CategoryType> getPredictedCategories(CategoryType target) {
        Map<CategoryType, Entry> subMap = this.confusions.get(target);
        if (subMap == null) {
            return Collections.emptySet();
        }
        return subMap.keySet();
    }

    public String toString() {
        return this.confusions.toString();
    }

    public static <CategoryType> DefaultConfusionMatrix<CategoryType> createUnweighted(Collection<? extends TargetEstimatePair<? extends CategoryType, ? extends CategoryType>> pairs) {
        DefaultConfusionMatrix<CategoryType> result = new DefaultConfusionMatrix<CategoryType>();
        for (TargetEstimatePair<CategoryType, CategoryType> item : pairs) {
            result.add(item.getTarget(), item.getEstimate());
        }
        return result;
    }

    public static <CategoryType> DefaultConfusionMatrix<CategoryType> createFromActualPredictedPairs(Collection<? extends Pair<? extends CategoryType, ? extends CategoryType>> pairs) {
        DefaultConfusionMatrix<CategoryType> result = new DefaultConfusionMatrix<CategoryType>();
        for (Pair<CategoryType, CategoryType> pair : pairs) {
            result.add(pair.getFirst(), pair.getSecond());
        }
        return result;
    }

    public static class CombineSummarizer<CategoryType>
    extends AbstractCloneableSerializable
    implements Summarizer<ConfusionMatrix<CategoryType>, DefaultConfusionMatrix<CategoryType>> {
        @Override
        public DefaultConfusionMatrix<CategoryType> summarize(Collection<? extends ConfusionMatrix<CategoryType>> data) {
            DefaultConfusionMatrix result = new DefaultConfusionMatrix();
            for (ConfusionMatrix<CategoryType> item : data) {
                result.addAll(item);
            }
            return result;
        }
    }

    public static class ActualPredictedPairSummarizer<CategoryType>
    extends AbstractCloneableSerializable
    implements Summarizer<Pair<? extends CategoryType, ? extends CategoryType>, DefaultConfusionMatrix<CategoryType>> {
        @Override
        public DefaultConfusionMatrix<CategoryType> summarize(Collection<? extends Pair<? extends CategoryType, ? extends CategoryType>> data) {
            return DefaultConfusionMatrix.createFromActualPredictedPairs(data);
        }
    }

    private static class Entry
    extends AbstractCloneableSerializable {
        protected double value;

        public Entry(double value) {
            this.value = value;
        }

        @Override
        public Entry clone() {
            return (Entry)super.clone();
        }

        public void increment(double count) {
            this.value += count;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public String toString() {
            return "" + this.value;
        }
    }
}

