/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math;

import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.RingAccumulator;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.util.DefaultPair;
import gov.sandia.cognition.util.Pair;
import gov.sandia.cognition.util.WeightedValue;
import java.util.Collection;

public class MultivariateStatisticsUtil {
    public static <RingType extends Ring<RingType>> RingType computeSum(Iterable<? extends RingType> data) {
        RingAccumulator<RingType> sum = new RingAccumulator<RingType>(data);
        return sum.getSum();
    }

    public static <RingType extends Ring<RingType>> RingType computeMean(Iterable<? extends RingType> data) {
        RingAccumulator<RingType> mean = new RingAccumulator<RingType>(data);
        return mean.getMean();
    }

    public static Matrix computeVariance(Collection<? extends Vector> data) {
        Pair<Vector, Matrix> result = MultivariateStatisticsUtil.computeMeanAndCovariance(data);
        return result != null ? result.getSecond() : null;
    }

    public static Matrix computeVariance(Collection<? extends Vector> data, Vector mean) {
        Matrix covariance;
        if (data.size() == 0) {
            return null;
        }
        RingAccumulator<Matrix> scatter = new RingAccumulator<Matrix>();
        for (Vector vector : data) {
            Vector delta = vector.minus(mean);
            scatter.accumulate(delta.outerProduct(delta));
        }
        int n = data.size();
        if (n >= 2) {
            covariance = (Matrix)((Matrix)scatter.getSum()).scale(1.0 / (double)(n - 1));
        } else {
            covariance = (Matrix)scatter.getSum();
            covariance.zero();
        }
        return covariance;
    }

    /*
     * WARNING - void declaration
     */
    public static Pair<Vector, Matrix> computeMeanAndCovariance(Iterable<? extends Vectorizable> data) {
        void var6_9;
        Vector mean;
        RingAccumulator<Vector> sum = new RingAccumulator<Vector>();
        Matrix sum2 = null;
        int dim = 0;
        int n = 0;
        for (Vectorizable vectorizable : data) {
            Vector x = vectorizable.convertToVector();
            sum.accumulate(x);
            if (sum2 == null) {
                dim = x.getDimensionality();
                sum2 = MatrixFactory.getDefault().createMatrix(dim, dim);
            }
            for (int i = 0; i < dim; ++i) {
                for (int j = 0; j < dim; ++j) {
                    double v = sum2.getElement(i, j);
                    sum2.setElement(i, j, v += x.getElement(i) * x.getElement(j));
                }
            }
            ++n;
        }
        if (n >= 2) {
            Vector s2 = (Vector)((Vector)sum.getSum()).scale(1.0 / (double)(n - 1));
            mean = (Vector)sum.getSum();
            mean.scaleEquals(1.0 / (double)n);
            Matrix matrix = ((Matrix)sum2.scale(1.0 / (double)(n - 1))).minus(mean.outerProduct(s2));
        } else if (n == 1) {
            mean = (Vector)sum.getSum();
            Matrix matrix = MatrixFactory.getDefault().createMatrix(dim, dim);
        } else {
            return null;
        }
        return DefaultPair.create(mean, var6_9);
    }

    /*
     * WARNING - void declaration
     */
    public static Pair<Vector, Matrix> computeWeightedMeanAndCovariance(Iterable<? extends WeightedValue<? extends Vectorizable>> data) {
        void var8_10;
        Vector mean;
        RingAccumulator<Vector> s1 = new RingAccumulator<Vector>();
        int dim = 0;
        Ring s2 = null;
        int N = 0;
        double weightSum = 0.0;
        for (WeightedValue<? extends Vectorizable> weightedValue : data) {
            double weight;
            ++N;
            Vector v2 = weightedValue.getValue().convertToVector();
            if (s2 == null) {
                dim = v2.getDimensionality();
                s2 = MatrixFactory.getDefault().createMatrix(dim, dim);
            }
            if ((weight = weightedValue.getWeight()) == 0.0) continue;
            weightSum += weight;
            Vector wx = v2;
            if (weight != 1.0) {
                wx = (Vector)wx.scale(weight);
            }
            s1.accumulate(wx);
            for (int i = 0; i < dim; ++i) {
                for (int j = 0; j < dim; ++j) {
                    double v = s2.getElement(i, j);
                    s2.setElement(i, j, v += wx.getElement(i) * v2.getElement(j));
                }
            }
        }
        if (N >= 2) {
            mean = (Vector)((Vector)s1.getSum()).scale(1.0 / weightSum);
            Matrix matrix = ((Matrix)s2.scale(1.0 / weightSum)).minus(mean.outerProduct(mean));
        } else if (N == 1) {
            mean = (Vector)((Vector)s1.getSum()).scale(1.0 / weightSum);
            Matrix matrix = MatrixFactory.getDefault().createMatrix(dim, dim);
        } else {
            return null;
        }
        return DefaultPair.create(mean, var8_10);
    }
}

