/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.geometry;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.collection.DefaultMultiCollection;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.math.matrix.mtj.Vector2;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-12-02", changesNeeded=false, comments={"Made Quadtree and Node extend AbstractCloneableSerializable", "Otherwise, class looks great!"})
public class Quadtree<DataType extends Vectorizable>
extends AbstractCloneableSerializable {
    public static final int DEFAULT_SPLIT_THRESHOLD = 10;
    protected int splitThreshold;
    protected LinkedList<DataType> items = new LinkedList();
    protected Rectangle2D.Double initalBounds;
    protected Node root = new Node(null, null);

    public Quadtree() {
        this(10);
    }

    public Quadtree(int splitThreshold) {
        this(splitThreshold, (Rectangle2D.Double)null);
    }

    public Quadtree(Rectangle2D.Double initialBounds) {
        this(10, initialBounds);
    }

    public Quadtree(int splitThreshold, Rectangle2D.Double initialBounds) {
        this.setSplitThreshold(splitThreshold);
    }

    public Quadtree(Collection<? extends DataType> items) {
        this(10, items);
    }

    public Quadtree(int splitThreshold, Collection<? extends DataType> items) {
        this(splitThreshold);
        this.items.addAll(items);
        this.rebuild();
    }

    public void add(DataType item) {
        Vector2 point = this.convertTo2D(item);
        this.items.add(item);
        if (!this.root.boundsContain(point)) {
            this.rebuild();
        } else {
            Node node = this.find(point);
            node.getLocalItems().add(item);
            if (this.shouldSplit(node)) {
                this.split(node);
            }
        }
    }

    public void addAll(Collection<? extends DataType> newItems) {
        boolean containsAll = true;
        for (Vectorizable item : newItems) {
            if (this.root.isInBounds(item)) continue;
            containsAll = false;
            break;
        }
        if (!containsAll) {
            this.items.addAll(newItems);
            this.rebuild();
        } else {
            for (Vectorizable item : newItems) {
                this.add(item);
            }
        }
    }

    protected void rebuild() {
        this.root = null;
        Rectangle2D.Double bounds = this.computeBounds(this.items);
        this.root = new Node(null, bounds);
        this.root.getLocalItems().addAll(this.items);
        if (this.shouldSplit(this.root)) {
            this.split(this.root);
        }
    }

    protected Rectangle2D.Double computeBounds(Collection<? extends DataType> items) {
        Rectangle2D.Double bounds = this.initalBounds;
        for (Vectorizable item : this.items) {
            Vector2 point = this.convertTo2D(item);
            if (bounds == null) {
                bounds = new Rectangle2D.Double(point.getX(), point.getY(), 0.0, 0.0);
                continue;
            }
            bounds.add(point.getX(), point.getY());
        }
        if (bounds != null) {
            double size;
            bounds.width = size = Math.max(bounds.getWidth(), bounds.getHeight());
            bounds.height = size;
        }
        return bounds;
    }

    protected boolean shouldSplit(Node node) {
        return node.getLocalCount() > this.splitThreshold;
    }

    protected void split(Node node) {
        if (node == null) {
            return;
        }
        if (!node.isLeaf()) {
            throw new IllegalArgumentException("Only leaf nodes can be split");
        }
        if (node.areLocalItemsSame()) {
            return;
        }
        Rectangle2D.Double bounds = node.getBounds();
        double minX = bounds.getMinX();
        double minY = bounds.getMinY();
        double midX = bounds.getCenterX();
        double midY = bounds.getCenterY();
        double splitWidth = midX - minX;
        double splitHeight = midY - minY;
        node.setLowerLeft(new Node(node, new Rectangle2D.Double(minX, minY, splitWidth, splitHeight)));
        node.setLowerRight(new Node(node, new Rectangle2D.Double(midX, minY, splitWidth, splitHeight)));
        node.setUpperLeft(new Node(node, new Rectangle2D.Double(minX, midY, splitWidth, splitHeight)));
        node.setUpperRight(new Node(node, new Rectangle2D.Double(midX, midY, splitWidth, splitHeight)));
        ArrayList<Node> children = new ArrayList<Node>(4);
        children.add(node.getLowerLeft());
        children.add(node.getLowerRight());
        children.add(node.getUpperLeft());
        children.add(node.getUpperRight());
        node.setChildren(children);
        for (Vectorizable item : node.getLocalItems()) {
            Node child = node.findChild(item);
            child.localItems.add(item);
        }
        node.localItems.clear();
        for (Node child : children) {
            if (!this.shouldSplit(child)) continue;
            this.split(child);
        }
    }

    public Vector2 convertTo2D(DataType item) {
        Vector vector = item.convertToVector();
        if (vector.getDimensionality() != 2) {
            throw new IllegalArgumentException("Quadtree only accepts two-dimensional data");
        }
        return new Vector2(vector);
    }

    public Node find(DataType item) {
        return this.find(this.convertTo2D(item));
    }

    public Node find(Vector2 point) {
        return this.find(point.getX(), point.getY());
    }

    public Node find(double x, double y) {
        Node node;
        if (!this.boundsContain(x, y)) {
            return null;
        }
        for (node = this.root; node != null && !node.isLeaf(); node = node.findChild(x, y)) {
        }
        return node;
    }

    public LinkedList<DataType> findItems(Rectangle2D rectangle) {
        LinkedList result = new LinkedList();
        this.root.findItems(rectangle, result);
        return result;
    }

    public LinkedList<Node> findNodes(Rectangle2D rectangle) {
        LinkedList<Node> result = new LinkedList<Node>();
        this.findNodes(rectangle, this.root, result);
        return result;
    }

    private void findNodes(Rectangle2D rectangle, Node node, LinkedList<Node> result) {
        if (node.boundsOverlap(rectangle)) {
            if (node.isLeaf() || rectangle.contains(node.bounds)) {
                result.add(node);
            } else {
                for (Node child : node.children) {
                    this.findNodes(rectangle, child, result);
                }
            }
        }
    }

    public boolean boundsContain(DataType item) {
        return this.boundsContain(this.convertTo2D(item));
    }

    public boolean boundsContain(Vector2 point) {
        return this.boundsContain(point.getX(), point.getY());
    }

    public boolean boundsContain(double x, double y) {
        return this.root.boundsContain(x, y);
    }

    public int getSplitThreshold() {
        return this.splitThreshold;
    }

    public void setSplitThreshold(int splitThreshold) {
        if (splitThreshold <= 0) {
            throw new IllegalArgumentException("splitThreshold must be positive.");
        }
        if (splitThreshold == this.splitThreshold) {
            return;
        }
        this.splitThreshold = splitThreshold;
        this.rebuild();
    }

    public Node getRoot() {
        return this.root;
    }

    public class Node
    extends AbstractCloneableSerializable {
        protected Node parent;
        protected Rectangle2D.Double bounds;
        protected int depth;
        protected LinkedList<DataType> localItems;
        protected Node lowerRight;
        protected Node lowerLeft;
        protected Node upperLeft;
        protected Node upperRight;
        protected ArrayList<Node> children;

        public Node(Node parent, Rectangle2D.Double bounds) {
            this.setParent(parent);
            this.setBounds(bounds);
            this.setDepth(parent == null ? 0 : parent.getDepth() + 1);
            this.setLocalItems(new LinkedList());
            this.setUpperLeft(null);
            this.setUpperRight(null);
            this.setLowerLeft(null);
            this.setLowerRight(null);
            this.setChildren(null);
        }

        public boolean isInBounds(DataType item) {
            return this.boundsContain(Quadtree.this.convertTo2D(item));
        }

        public boolean boundsContain(Vector2 point) {
            return this.boundsContain(point.getX(), point.getY());
        }

        public boolean boundsContain(Point2D point) {
            return this.boundsContain(point.getX(), point.getY());
        }

        public boolean boundsContain(double x, double y) {
            return this.bounds != null && x >= this.bounds.getMinX() && y >= this.bounds.getMinY() && x <= this.bounds.getMaxX() && y <= this.bounds.getMaxY();
        }

        public boolean boundsContain(Rectangle2D rectangle) {
            return this.bounds != null && rectangle.getMinX() >= this.bounds.getMinX() && rectangle.getMinY() >= this.bounds.getMinY() && rectangle.getMaxX() <= this.bounds.getMaxX() && rectangle.getMaxY() <= this.bounds.getMaxY();
        }

        public boolean boundsOverlap(Rectangle2D rectangle) {
            return this.bounds.intersects(rectangle);
        }

        public Node findChild(DataType item) {
            return this.findChild(Quadtree.this.convertTo2D(item));
        }

        public Node findChild(Vector2 point) {
            return this.findChild(point.getX(), point.getY());
        }

        public Node findChild(double x, double y) {
            if (this.isLeaf()) {
                return null;
            }
            if (x <= this.bounds.getCenterX()) {
                if (y <= this.bounds.getCenterY()) {
                    return this.lowerLeft;
                }
                return this.upperLeft;
            }
            if (y <= this.bounds.getCenterY()) {
                return this.lowerRight;
            }
            return this.upperRight;
        }

        public void findItems(Rectangle2D rectangle, LinkedList<DataType> result) {
            block6: {
                if (!this.boundsOverlap(rectangle)) break block6;
                if (rectangle.contains(this.bounds)) {
                    result.addAll(this.getItems());
                } else if (this.isLeaf()) {
                    for (Vectorizable item : this.localItems) {
                        Vector2 point = Quadtree.this.convertTo2D(item);
                        if (!rectangle.contains(point.getX(), point.getY())) continue;
                        result.add(item);
                    }
                } else {
                    for (Node child : this.children) {
                        child.findItems(rectangle, result);
                    }
                }
            }
        }

        public boolean areLocalItemsSame() {
            if (!this.isLeaf()) {
                return false;
            }
            if (this.getLocalCount() <= 1) {
                return true;
            }
            Vector2 first = Quadtree.this.convertTo2D((Vectorizable)this.localItems.getFirst());
            for (Vectorizable item : this.localItems) {
                Vector2 vector = Quadtree.this.convertTo2D(item);
                if (first.equals(vector)) continue;
                return false;
            }
            return true;
        }

        public Collection<DataType> getItems() {
            if (this.isLeaf()) {
                return this.localItems;
            }
            return new DefaultMultiCollection(new DefaultMultiCollection(this.lowerLeft.getItems(), this.lowerRight.getItems()), new DefaultMultiCollection(this.upperLeft.getItems(), this.upperRight.getItems()));
        }

        public List<Node> getChildren() {
            if (this.children == null) {
                return Collections.emptyList();
            }
            return this.children;
        }

        public boolean isEmpty() {
            return this.isLeaf() && this.getLocalCount() <= 0;
        }

        public boolean isLeaf() {
            return this.children == null;
        }

        public int getLocalCount() {
            return this.getLocalItems().size();
        }

        public int getDepth() {
            return this.depth;
        }

        protected void setDepth(int depth) {
            this.depth = depth;
        }

        public Node getParent() {
            return this.parent;
        }

        protected void setParent(Node parent) {
            this.parent = parent;
        }

        public Rectangle2D.Double getBounds() {
            return this.bounds;
        }

        protected void setBounds(Rectangle2D.Double bounds) {
            this.bounds = bounds;
        }

        public LinkedList<DataType> getLocalItems() {
            return this.localItems;
        }

        protected void setLocalItems(LinkedList<DataType> localItems) {
            this.localItems = localItems;
        }

        public Node getLowerLeft() {
            return this.lowerLeft;
        }

        protected void setLowerLeft(Node lowerLeft) {
            this.lowerLeft = lowerLeft;
        }

        public Node getLowerRight() {
            return this.lowerRight;
        }

        protected void setLowerRight(Node lowerRight) {
            this.lowerRight = lowerRight;
        }

        public Node getUpperLeft() {
            return this.upperLeft;
        }

        protected void setUpperLeft(Node upperLeft) {
            this.upperLeft = upperLeft;
        }

        public Node getUpperRight() {
            return this.upperRight;
        }

        protected void setUpperRight(Node upperRight) {
            this.upperRight = upperRight;
        }

        protected void setChildren(ArrayList<Node> children) {
            this.children = children;
        }
    }
}

