/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;

@CodeReview(reviewer={"Jonathan McClain"}, date="2006-05-19", changesNeeded=false, comments={"Looks fine."})
public class MatrixReader {
    private VectorReader internalReader = null;

    public MatrixReader(Reader reader) {
        this.setInternalReader(new VectorReader(reader));
    }

    protected VectorReader getInternalReader() {
        return this.internalReader;
    }

    protected void setInternalReader(VectorReader internalReader) {
        this.internalReader = internalReader;
    }

    public Matrix read() throws IOException {
        Matrix retval;
        boolean mustBeSameSize = true;
        List<Vector> rowVectors = this.getInternalReader().readCollection(mustBeSameSize);
        int N = -1;
        int index = 0;
        for (Vector r : rowVectors) {
            int numColumns = r.getDimensionality();
            if (N < 0) {
                N = numColumns;
            } else if (N != numColumns) {
                throw new IOException("Row " + index + " has different dimension than previous rows!");
            }
            ++index;
        }
        int M = rowVectors.size();
        if (M <= 0) {
            retval = null;
        } else {
            retval = MatrixFactory.getDefault().createMatrix(M, N);
            int rowIndex = 0;
            for (Vector r : rowVectors) {
                retval.setRow(rowIndex, r);
                ++rowIndex;
            }
        }
        return retval;
    }
}

