/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviewResponse;
import gov.sandia.cognition.io.ReaderTokenizer;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

@CodeReview(reviewer={"Jonathan McClain"}, date="2006-05-22", changesNeeded=true, comments={"Changes marked by triple slash"}, response={@CodeReviewResponse(respondent="Justin Basilico", date="2006-07-20", moreChangesNeeded=false, comments={"Changes from J.T.'s code review"})})
public class VectorReader {
    public static final String COMMENT_LINE_PREFIX = "#";
    private ReaderTokenizer tokenizer;

    public VectorReader(Reader reader) {
        this(new ReaderTokenizer(reader));
    }

    public VectorReader(ReaderTokenizer tokenizer) {
        this.setTokenizer(tokenizer);
    }

    public Vector read() throws IOException {
        Vector retval;
        ArrayList<String> tokens = this.getTokenizer().readNextLine();
        if (tokens != null) {
            ArrayList<Double> values = new ArrayList<Double>(tokens.size());
            for (String token : tokens) {
                values.add(Double.valueOf(token));
            }
            int M = values.size();
            if (M > 0) {
                retval = VectorFactory.getDefault().createVector(M);
                for (int i = 0; i < M; ++i) {
                    retval.setElement(i, (Double)values.get(i));
                }
            } else {
                retval = null;
            }
        } else {
            retval = null;
        }
        return retval;
    }

    public static Vector parseVector(Collection<String> tokens) {
        if (tokens == null) {
            return null;
        }
        int dimensionality = tokens.size();
        if (dimensionality <= 0) {
            return null;
        }
        Vector vector = VectorFactory.getDefault().createVector(dimensionality);
        int i = 0;
        for (String token : tokens) {
            double value = Double.valueOf(token);
            vector.setElement(i, value);
            ++i;
        }
        return vector;
    }

    public List<Vector> readCollection(boolean mustBeSameSize) throws IOException {
        LinkedList<Vector> vectors = new LinkedList<Vector>();
        ArrayList<String> tokens = null;
        int N = -1;
        while ((tokens = this.getTokenizer().readNextLine()) != null) {
            Vector rowVector;
            String first;
            if (tokens.size() <= 0 || (first = tokens.get(0).trim()).startsWith(COMMENT_LINE_PREFIX) || (rowVector = VectorReader.parseVector(tokens)) == null) continue;
            vectors.add(rowVector);
            if (!mustBeSameSize) continue;
            if (N < 0) {
                N = rowVector.getDimensionality();
                continue;
            }
            if (N == rowVector.getDimensionality()) continue;
            throw new IOException("Expected " + N + " elements in row " + (vectors.size() + 1));
        }
        return vectors;
    }

    protected ReaderTokenizer getTokenizer() {
        return this.tokenizer;
    }

    protected void setTokenizer(ReaderTokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }
}

