/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.decomposition;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviewResponse;
import gov.sandia.cognition.math.ComplexNumber;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.decomposition.EigenDecomposition;
import gov.sandia.cognition.util.ArrayIndexSorter;

@CodeReview(reviewer={"Jonathan McClain"}, date="2006-05-16", changesNeeded=true, comments={"Comments indicated by triple slashes", "Some refactoring needed here.", "Another review needed after refactoring."}, response={@CodeReviewResponse(respondent="Kevin R. Dixon", date="2006-05-17", moreChangesNeeded=true, comments={"Fixes from J.T.'s code review"}), @CodeReviewResponse(respondent="Jonathan McClain", date="2006-05-17", moreChangesNeeded=false, comments={"Rechecking after changes were made. Looks good now."})})
public abstract class AbstractEigenDecomposition
implements EigenDecomposition {
    private ComplexNumber[] eigenValues;
    private Matrix eigenVectorsRealPart;
    private Matrix eigenVectorsImaginaryPart;

    protected AbstractEigenDecomposition(ComplexNumber[] eigenValues, Matrix eigenVectorsRealPart, Matrix eigenVectorsImaginaryPart) {
        this.setEigenValues(eigenValues);
        this.setEigenVectorsRealPart(eigenVectorsRealPart);
        this.setEigenVectorsImaginaryPart(eigenVectorsImaginaryPart);
    }

    protected AbstractEigenDecomposition(ComplexNumber[] eigenValues, Matrix eigenVectorsRealPart, Matrix eigenVectorsImaginaryPart, boolean sort) {
        this.setEigenDecomposition(eigenValues, eigenVectorsRealPart, eigenVectorsImaginaryPart, sort);
    }

    protected void setEigenDecomposition(ComplexNumber[] eigenValues, Matrix eigenVectorsRealPart, Matrix eigenVectorsImaginaryPart, boolean sort) {
        if (sort) {
            this.sortAndSetEigenDecomposition(eigenValues, eigenVectorsRealPart, eigenVectorsImaginaryPart);
        } else {
            this.setUnsortedEigenDecomposition(eigenValues, eigenVectorsRealPart, eigenVectorsImaginaryPart);
        }
    }

    protected void sortAndSetEigenDecomposition(ComplexNumber[] eigenValues, Matrix eigenVectorsRealPart, Matrix eigenVectorsImaginaryPart) {
        int M = eigenValues.length;
        double[] magnitudes = new double[M];
        for (int i = 0; i < M; ++i) {
            magnitudes[i] = eigenValues[i].getMagnitude();
        }
        int[] indices = ArrayIndexSorter.sortArrayDescending(magnitudes);
        ComplexNumber[] sortedEigenValues = new ComplexNumber[M];
        Matrix sortedEigenVectorsRealPart = eigenVectorsRealPart.clone();
        Matrix sortedEigenVectorsImaginaryPart = eigenVectorsImaginaryPart.clone();
        for (int j = 0; j < M; ++j) {
            sortedEigenValues[j] = eigenValues[indices[j]];
            for (int i = 0; i < M; ++i) {
                sortedEigenVectorsRealPart.setElement(i, j, eigenVectorsRealPart.getElement(i, indices[j]));
                sortedEigenVectorsImaginaryPart.setElement(i, j, eigenVectorsImaginaryPart.getElement(i, indices[j]));
            }
        }
        this.setUnsortedEigenDecomposition(sortedEigenValues, sortedEigenVectorsRealPart, sortedEigenVectorsImaginaryPart);
    }

    protected void setUnsortedEigenDecomposition(ComplexNumber[] eigenValues, Matrix eigenVectorsRealPart, Matrix eigenVectorsImaginaryPart) {
        this.setEigenValues(eigenValues);
        this.setEigenVectorsRealPart(eigenVectorsRealPart);
        this.setEigenVectorsImaginaryPart(eigenVectorsImaginaryPart);
    }

    @Override
    public ComplexNumber[] getEigenValues() {
        return this.eigenValues;
    }

    protected void setEigenValues(ComplexNumber[] eigenValues) {
        this.eigenValues = eigenValues;
    }

    @Override
    public ComplexNumber getEigenValue(int index) {
        return this.getEigenValues()[index];
    }

    @Override
    public Matrix getEigenVectorsRealPart() {
        return this.eigenVectorsRealPart;
    }

    protected void setEigenVectorsRealPart(Matrix eigenVectorsRealPart) {
        this.eigenVectorsRealPart = eigenVectorsRealPart;
    }

    @Override
    public Matrix getEigenVectorsImaginaryPart() {
        return this.eigenVectorsImaginaryPart;
    }

    public void setEigenVectorsImaginaryPart(Matrix eigenVectorsImaginaryPart) {
        this.eigenVectorsImaginaryPart = eigenVectorsImaginaryPart;
    }

    @Override
    public ComplexNumber getLogDeterminant() {
        ComplexNumber[] eigenvalues;
        ComplexNumber logsum = new ComplexNumber(0.0, 0.0);
        for (ComplexNumber c : eigenvalues = this.getEigenValues()) {
            logsum.plusEquals(c.computeNaturalLogarithm());
        }
        return logsum;
    }
}

