/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.mtj;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviewResponse;
import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorEntry;
import gov.sandia.cognition.math.matrix.VectorReader;
import gov.sandia.cognition.math.matrix.mtj.AbstractMTJVector;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrix;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

@CodeReview(reviewer={"Jonathan McClain"}, date="2006-05-19", changesNeeded=true, comments={"Comments marked with / / /"}, response={@CodeReviewResponse(respondent="Kevin R. Dixon", date="2006-05-22", moreChangesNeeded=false, comments={"Fixed comments for writeObject() and readObject()"})})
@PublicationReference(author={"Bjorn-Ove Heimsund"}, title="MTJ DenseVector javadoc", type=PublicationType.WebPage, year=2006, url="http://ressim.berlios.de/doc/no/uib/cipr/matrix/DenseVector.html")
public class DenseVector
extends AbstractMTJVector
implements Serializable {
    protected DenseVector(int numDimensions) {
        super(new no.uib.cipr.matrix.DenseVector(numDimensions));
        if (numDimensions < 0) {
            throw new IllegalArgumentException("Vector must have non-negative dimensionality");
        }
    }

    protected DenseVector(DenseVector vector) {
        super((no.uib.cipr.matrix.DenseVector)vector.getInternalVector().copy());
    }

    protected DenseVector(Vector vector) {
        this(vector.getDimensionality());
        for (VectorEntry e : vector) {
            this.setElement(e.getIndex(), e.getValue());
        }
    }

    protected DenseVector(AbstractMTJVector vector) {
        super(new no.uib.cipr.matrix.DenseVector(vector.getInternalVector()));
    }

    protected DenseVector(double[] values) {
        this(new no.uib.cipr.matrix.DenseVector(values));
    }

    protected DenseVector(no.uib.cipr.matrix.DenseVector internalVector) {
        super(internalVector);
    }

    protected DenseVector(VectorReader reader) throws IOException {
        this(reader.read());
    }

    protected void setInternalVector(no.uib.cipr.matrix.DenseVector internalVector) {
        super.setInternalVector(internalVector);
    }

    @Override
    public boolean equals(Vector other, double effectiveZero) {
        double[] values = this.getArray();
        for (int i = 0; i < this.getDimensionality(); ++i) {
            double difference = values[i] - other.getElement(i);
            if (!(Math.abs(difference) > effectiveZero)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double euclideanDistanceSquared(Vector other) {
        this.assertSameDimensionality(other);
        double sumSquared = 0.0;
        double[] values = this.getArray();
        int M = this.getDimensionality();
        for (int i = 0; i < M; ++i) {
            double delta = values[i] - other.getElement(i);
            sumSquared += delta * delta;
        }
        return sumSquared;
    }

    @Override
    public DenseMatrix outerProduct(AbstractMTJVector other) {
        int M = this.getDimensionality();
        int N = other.getDimensionality();
        DenseMatrix retval = new DenseMatrix(M, N);
        double[] values = this.getArray();
        for (int i = 0; i < M; ++i) {
            for (int j = 0; j < N; ++j) {
                retval.setElement(i, j, values[i] * other.getElement(j));
            }
        }
        return retval;
    }

    @Override
    public DenseVector stack(Vector other) {
        int M1 = this.getDimensionality();
        int M2 = other.getDimensionality();
        DenseVector stacked = new DenseVector(M1 + M2);
        for (VectorEntry e : this) {
            stacked.setElement(e.getIndex(), e.getValue());
        }
        for (VectorEntry e : other) {
            stacked.setElement(M1 + e.getIndex(), e.getValue());
        }
        return stacked;
    }

    @Override
    public DenseVector subVector(int minIndex, int maxIndex) {
        int M = maxIndex - minIndex + 1;
        DenseVector retval = new DenseVector(M);
        double[] retvalValues = retval.getArray();
        double[] values = this.getArray();
        for (int i = 0; i < M; ++i) {
            retvalValues[i] = values[i + minIndex];
        }
        return retval;
    }

    public double[] getArray() {
        return ((no.uib.cipr.matrix.DenseVector)this.getInternalVector()).getData();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getArray());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        double[] data = (double[])in.readObject();
        boolean deepCopy = false;
        this.setInternalVector(new no.uib.cipr.matrix.DenseVector(data, deepCopy));
    }
}

