/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.mtj;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixEntry;
import gov.sandia.cognition.math.matrix.mtj.AbstractMTJMatrix;
import gov.sandia.cognition.math.matrix.mtj.AbstractSparseMatrix;
import gov.sandia.cognition.math.matrix.mtj.SparseColumnMatrix;
import gov.sandia.cognition.math.matrix.mtj.SparseVector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;

@CodeReview(reviewer={"Justin Basilico"}, date="2006-07-27", changesNeeded=false, comments={"Looks good."})
public class SparseRowMatrix
extends AbstractSparseMatrix {
    protected SparseRowMatrix(int numRows, int numColumns) {
        this(new FlexCompRowMatrix(numRows, numColumns));
        if (numRows < 0) {
            throw new IllegalArgumentException("Num rows must be >= 0");
        }
        if (numColumns < 0) {
            throw new IllegalArgumentException("Num columns must be >= 0");
        }
    }

    protected SparseRowMatrix(SparseRowMatrix matrix) {
        this((FlexCompRowMatrix)matrix.getInternalMatrix().copy());
    }

    protected SparseRowMatrix(Matrix matrix) {
        this(matrix.getNumRows(), matrix.getNumColumns());
        for (MatrixEntry e : matrix) {
            double value = e.getValue();
            if (value == 0.0) continue;
            this.setElement(e.getRowIndex(), e.getColumnIndex(), value);
        }
    }

    protected SparseRowMatrix(FlexCompRowMatrix internalMatrix) {
        super(internalMatrix);
    }

    @Override
    public FlexCompRowMatrix getInternalMatrix() {
        return (FlexCompRowMatrix)super.getInternalMatrix();
    }

    @Override
    public SparseColumnMatrix transpose() {
        SparseColumnMatrix result = new SparseColumnMatrix(this.getNumColumns(), this.getNumRows());
        this.transposeInto(result);
        return result;
    }

    @Override
    public SparseRowMatrix times(AbstractMTJMatrix matrix) {
        int returnRows = this.getNumRows();
        int returnColumns = matrix.getNumColumns();
        SparseRowMatrix result = new SparseRowMatrix(returnRows, returnColumns);
        this.timesInto(matrix, result);
        return result;
    }

    @Override
    public SparseRowMatrix getSubMatrix(int minRow, int maxRow, int minColumn, int maxColumn) {
        if (minRow > maxRow) {
            throw new IllegalArgumentException("minRow > maxRow");
        }
        if (minColumn > maxColumn) {
            throw new IllegalArgumentException("minColumn > maxColumn");
        }
        int numRows = maxRow - minRow + 1;
        int numColumns = maxColumn - minColumn + 1;
        SparseRowMatrix submatrix = new SparseRowMatrix(numRows, numColumns);
        this.getSubMatrixInto(minRow, maxRow, minColumn, maxColumn, submatrix);
        return submatrix;
    }

    @Override
    public SparseVector getRow(int rowIndex) {
        return new SparseVector(this.getInternalMatrix().getRow(rowIndex));
    }

    public void setRow(int rowIndex, SparseVector rowVector) {
        this.getInternalMatrix().setRow(rowIndex, rowVector.getInternalVector());
    }

    @Override
    public void compact() {
        this.getInternalMatrix().compact();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int numRows = in.readInt();
        int numCols = in.readInt();
        this.setInternalMatrix(new FlexCompRowMatrix(numRows, numCols));
        for (int i = 0; i < numRows; ++i) {
            SparseVector row = (SparseVector)in.readObject();
            this.setRow(i, row);
        }
        this.compact();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.compact();
        out.defaultWriteObject();
        int numRows = this.getNumRows();
        int numCols = this.getNumColumns();
        out.writeInt(numRows);
        out.writeInt(numCols);
        for (int i = 0; i < numRows; ++i) {
            out.writeObject(this.getRow(i));
        }
    }
}

