/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.mtj.decomposition;

import gov.sandia.cognition.math.matrix.mtj.DenseMatrix;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrixFactoryMTJ;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import no.uib.cipr.matrix.DenseCholesky;

public class CholeskyDecompositionMTJ
extends AbstractCloneableSerializable {
    private DenseMatrix R;

    public static CholeskyDecompositionMTJ create(DenseMatrix A) {
        DenseCholesky cholesky = DenseCholesky.factorize(A.getInternalMatrix());
        if (!cholesky.isSPD()) {
            throw new IllegalArgumentException("Matrix must be symmetric and positive definite!");
        }
        DenseMatrix R = DenseMatrixFactoryMTJ.INSTANCE.createWrapper(new no.uib.cipr.matrix.DenseMatrix(cholesky.getU()));
        return new CholeskyDecompositionMTJ(R);
    }

    private CholeskyDecompositionMTJ(DenseMatrix R) {
        this.setR(R);
    }

    public DenseMatrix getR() {
        return this.R;
    }

    public void setR(DenseMatrix R) {
        this.R = R;
    }
}

