/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.signals;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.evaluator.AbstractStatefulEvaluator;
import gov.sandia.cognition.util.AbstractCloneableSerializable;

@PublicationReferences(references={@PublicationReference(author={"Control Tutorial for MATLAB"}, title="PID Tutorial", type=PublicationType.WebPage, year=1997, url="http://www.engin.umich.edu/group/ctm/PID/PID.html"), @PublicationReference(author={"Wikipedia"}, title="PID Controller", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/PID_controller", notes={"This article pretty much sucks"})})
public class PIDController
extends AbstractStatefulEvaluator<Double, Double, State> {
    private double targetInput;
    private double proportionalGain;
    private double integralGain;
    private double derivativeGain;
    public static final double DEFAULT_PROPORTIONAL_GAIN = 0.5;
    public static final double DEFAULT_INTEGRAL_GAIN = 0.0;
    public static final double DEFAULT_DERIVATIVE_GAIN = 0.25;

    public PIDController() {
        this(0.5, 0.0, 0.25);
    }

    public PIDController(double proportionalGain, double integralGain, double derivativeGain) {
        this(proportionalGain, integralGain, derivativeGain, 0.0);
    }

    public PIDController(double proportionalGain, double integralGain, double derivativeGain, double targetInput) {
        this.setProportionalGain(proportionalGain);
        this.setIntegralGain(integralGain);
        this.setDerivativeGain(derivativeGain);
        this.setTargetInput(targetInput);
    }

    public double getTargetInput() {
        return this.targetInput;
    }

    public void setTargetInput(double targetInput) {
        this.targetInput = targetInput;
    }

    public double getProportionalGain() {
        return this.proportionalGain;
    }

    public void setProportionalGain(double proportionalGain) {
        this.proportionalGain = proportionalGain;
    }

    public double getIntegralGain() {
        return this.integralGain;
    }

    public void setIntegralGain(double integralGain) {
        this.integralGain = integralGain;
    }

    public double getDerivativeGain() {
        return this.derivativeGain;
    }

    public void setDerivativeGain(double derivativeGain) {
        this.derivativeGain = derivativeGain;
    }

    @Override
    public Double evaluate(Double input) {
        double err = this.targetInput - input;
        double errSum = err + ((State)this.getState()).getErrSum();
        double diffErr = err - ((State)this.getState()).getLastErr();
        ((State)this.getState()).setErrSum(errSum);
        ((State)this.getState()).setLastErr(err);
        double pid = this.proportionalGain * err + this.integralGain * errSum + this.derivativeGain * diffErr;
        return pid;
    }

    @Override
    public State createDefaultState() {
        return new State();
    }

    public static class State
    extends AbstractCloneableSerializable {
        private double lastErr;
        private double errSum;

        public State() {
            this(0.0, 0.0);
        }

        public State(double lastErr, double errSum) {
            this.setLastErr(lastErr);
            this.setErrSum(errSum);
        }

        public double getLastErr() {
            return this.lastErr;
        }

        public void setLastErr(double lastErr) {
            this.lastErr = lastErr;
        }

        public double getErrSum() {
            return this.errSum;
        }

        public void setErrSum(double errSum) {
            this.errSum = errSum;
        }
    }
}

