/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics;

import gov.sandia.cognition.statistics.AbstractDistribution;
import gov.sandia.cognition.statistics.DataHistogram;

public abstract class AbstractDataHistogram<DataType>
extends AbstractDistribution<DataType>
implements DataHistogram<DataType> {
    @Override
    public void add(DataType value) {
        this.add(value, 1);
    }

    @Override
    public void remove(DataType value) {
        this.remove(value, 1);
    }

    @Override
    public double getFraction(DataType value) {
        int tc = this.getTotalCount();
        if (tc <= 0) {
            return 0.0;
        }
        return (double)this.getCount(value) / (double)tc;
    }

    @Override
    public void addAll(Iterable<? extends DataType> values) {
        for (DataType value : values) {
            this.add(value);
        }
    }

    @Override
    public <OtherDataType extends DataType> void addAll(DataHistogram<OtherDataType> other) {
        for (Object value : other.getDomain()) {
            this.add(value, other.getCount(value));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getTotalCount() == 0;
    }
}

