/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics;

import gov.sandia.cognition.math.Permutation;
import gov.sandia.cognition.math.matrix.Vector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class DiscreteSamplingUtil {
    public static int sampleIndexFromProbabilities(Random random, double[] probabilities) {
        double value = random.nextDouble();
        int lastIndex = probabilities.length - 1;
        for (int i = 0; i < lastIndex; ++i) {
            if (!((value -= probabilities[i]) <= 0.0)) continue;
            return i;
        }
        return lastIndex;
    }

    public static int sampleIndexFromProbabilities(Random random, Vector probabilities) {
        double value = random.nextDouble();
        int lastIndex = probabilities.getDimensionality() - 1;
        for (int i = 0; i < lastIndex; ++i) {
            if (!((value -= probabilities.getElement(i)) <= 0.0)) continue;
            return i;
        }
        return lastIndex;
    }

    public static int sampleIndexFromProportions(Random random, double[] proportions) {
        double proportionSum = 0.0;
        for (double value : proportions) {
            proportionSum += value;
        }
        return DiscreteSamplingUtil.sampleIndexFromProportions(random, proportions, proportionSum);
    }

    public static int[] sampleIndicesFromProportions(Random random, double[] proportions, int sampleSize) {
        int length = proportions.length;
        double proportionSum = 0.0;
        if (sampleSize == 1) {
            for (double value : proportions) {
                proportionSum += value;
            }
            int randomIndex = DiscreteSamplingUtil.sampleIndexFromProportions(random, proportions, proportionSum);
            return new int[]{randomIndex};
        }
        double[] cumulativeProportions = new double[length];
        for (int i = 0; i < length; ++i) {
            cumulativeProportions[i] = proportionSum += proportions[i];
        }
        return DiscreteSamplingUtil.sampleIndicesFromCumulativeProportions(random, cumulativeProportions, sampleSize);
    }

    public static int sampleIndexFromProportions(Random random, double[] proportions, double proportionSum) {
        double value = random.nextDouble() * proportionSum;
        int lastIndex = proportions.length - 1;
        for (int i = 0; i < lastIndex; ++i) {
            if (!((value -= proportions[i]) <= 0.0)) continue;
            return i;
        }
        return lastIndex;
    }

    public static int sampleIndexFromCumulativeProportions(Random random, double[] cumulativeProportions) {
        int lastIndex = cumulativeProportions.length - 1;
        double sum = cumulativeProportions[lastIndex];
        double value = random.nextDouble() * sum;
        int index = Arrays.binarySearch(cumulativeProportions, value);
        if (index < 0) {
            int insertionPoint;
            index = insertionPoint = -index - 1;
        }
        return index;
    }

    public static int[] sampleIndicesFromCumulativeProportions(Random random, double[] cumulativeProportions, int sampleSize) {
        int[] result = new int[sampleSize];
        for (int i = 0; i < sampleSize; ++i) {
            result[i] = DiscreteSamplingUtil.sampleIndexFromCumulativeProportions(random, cumulativeProportions);
        }
        return result;
    }

    public static <DataType> ArrayList<DataType> sampleWithReplacement(Random random, List<? extends DataType> data, int sampleSize) {
        ArrayList result = new ArrayList(sampleSize);
        DiscreteSamplingUtil.sampleWithReplacementInto(random, data, sampleSize, result);
        return result;
    }

    public static <DataType> void sampleWithReplacementInto(Random random, List<? extends DataType> data, int sampleSize, Collection<? super DataType> result) {
        int dataSize = data.size();
        for (int i = 0; i < sampleSize; ++i) {
            int randomIndex = random.nextInt(dataSize);
            result.add(data.get(randomIndex));
        }
    }

    public static <DataType> List<DataType> sampleWithoutReplacement(Random random, List<DataType> data, int sampleSize) {
        int dataSize = data.size();
        if (sampleSize <= 0) {
            throw new IllegalArgumentException("sampleSized must be positive");
        }
        if (sampleSize == 1) {
            int randomIndex = random.nextInt(dataSize);
            return Collections.singletonList(data.get(randomIndex));
        }
        if (sampleSize < dataSize) {
            return Permutation.createReordering(data, random).subList(0, sampleSize);
        }
        if (sampleSize == dataSize) {
            return Collections.unmodifiableList(data);
        }
        throw new IllegalArgumentException("sampleSize (" + sampleSize + ") cannot be larger than " + "data size (" + dataSize + ")");
    }
}

