/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.learning.data.DefaultInputOutputPair;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.math.ProbabilityUtil;
import gov.sandia.cognition.math.UnivariateStatisticsUtil;
import gov.sandia.cognition.statistics.ClosedFormDiscreteUnivariateDistribution;
import gov.sandia.cognition.statistics.CumulativeDistributionFunction;
import gov.sandia.cognition.statistics.DiscreteDistribution;
import gov.sandia.cognition.statistics.ProbabilityMassFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class ProbabilityMassFunctionUtil {
    @PublicationReference(author={"Wikipedia"}, title="Entropy (information theory)", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Entropy_(Information_theory)")
    public static <DataType> double getEntropy(ProbabilityMassFunction<DataType> pmf) {
        Collection domain = pmf.getDomain();
        ArrayList data = new ArrayList(domain.size());
        for (Object input : domain) {
            data.add(pmf.evaluate(input));
        }
        return UnivariateStatisticsUtil.computeEntropy(data);
    }

    public static <DataType> ArrayList<DataType> sample(ProbabilityMassFunction<DataType> pmf, Random random, int numSamples) {
        ArrayList<Object> samples;
        if (numSamples == 1) {
            samples = new ArrayList(1);
            samples.add(ProbabilityMassFunctionUtil.sampleSingle(pmf, random));
        } else {
            samples = ProbabilityMassFunctionUtil.sampleMultiple(pmf, random, numSamples);
        }
        return samples;
    }

    public static <DataType> DataType sampleSingle(ProbabilityMassFunction<DataType> pmf, Random random) {
        double p = random.nextDouble();
        for (Object x : pmf.getDomain()) {
            if (!((p -= ((Double)pmf.evaluate(x)).doubleValue()) <= 0.0)) continue;
            return x;
        }
        return null;
    }

    public static <DataType> ArrayList<DataType> sampleMultiple(ProbabilityMassFunction<DataType> pmf, Random random, int numSamples) {
        int N = pmf.getDomain().size();
        double[] cumulativeProbabilities = new double[N];
        ArrayList domain = CollectionUtil.asArrayList(pmf.getDomain());
        double psum = 0.0;
        int domainSize = domain.size();
        for (int index = 0; index < domainSize; ++index) {
            Object x = domain.get(index);
            cumulativeProbabilities[index] = psum += ((Double)pmf.evaluate(x)).doubleValue();
        }
        return ProbabilityMassFunctionUtil.sampleMultiple(cumulativeProbabilities, psum, domain, random, numSamples);
    }

    public static <DataType> ArrayList<DataType> sampleMultiple(double[] cumulativeWeights, double weightSum, List<? extends DataType> domain, Random random, int numSamples) {
        ArrayList<DataType> samples = new ArrayList<DataType>(numSamples);
        for (int n = 0; n < numSamples; ++n) {
            double p = weightSum * random.nextDouble();
            int index = Arrays.binarySearch(cumulativeWeights, p);
            if (index < 0) {
                int insertionPoint;
                index = insertionPoint = -index - 1;
            }
            samples.add(domain.get(index));
        }
        return samples;
    }

    public static <DataType> DataType sampleSingle(double[] weights, Collection<? extends DataType> domain, Random random) {
        double sum = 0.0;
        int N = weights.length;
        for (int n = 0; n < N; ++n) {
            sum += weights[n];
        }
        double s = sum * random.nextDouble();
        int n = 0;
        for (DataType value : domain) {
            if (!((s -= weights[n]) <= 0.0)) continue;
            return value;
        }
        return null;
    }

    public static <DataType extends Number> InputOutputPair<DataType, Double> inverse(CumulativeDistributionFunction<DataType> cdf, double p) {
        ProbabilityUtil.assertIsProbability(p);
        for (Number x : ((DiscreteDistribution)((Object)cdf)).getDomain()) {
            double px = (Double)cdf.evaluate(x);
            if (!(p <= px)) continue;
            return new DefaultInputOutputPair<Number, Double>(x, px);
        }
        throw new IllegalArgumentException("Could not invert CDF for p=" + p);
    }

    public static double computeCumulativeValue(int input, ClosedFormDiscreteUnivariateDistribution<? super Integer> distribution) {
        int minx = ((Number)distribution.getMinSupport()).intValue();
        ProbabilityMassFunction pmf = distribution.getProbabilityFunction();
        double sum = 0.0;
        for (int x = minx; x <= input; ++x) {
            sum += ((Double)pmf.evaluate(x)).doubleValue();
        }
        return sum;
    }
}

