/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.statistics.AbstractRandomVariable;
import gov.sandia.cognition.statistics.CumulativeDistributionFunction;
import gov.sandia.cognition.statistics.RandomVariable;
import gov.sandia.cognition.statistics.UnivariateDistribution;
import gov.sandia.cognition.statistics.distribution.ScalarDataDistribution;
import gov.sandia.cognition.statistics.method.ConfidenceInterval;
import gov.sandia.cognition.statistics.method.GaussianConfidence;
import gov.sandia.cognition.statistics.method.KolmogorovSmirnovConfidence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Algebra of random variables", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Algebra_of_random_variables")
public class UnivariateRandomVariable
extends AbstractRandomVariable<Number>
implements UnivariateDistribution<Number> {
    public static final int DEFAULT_NUM_SAMPLES = 10000;
    private int numSamples;
    private Random random;
    private UnivariateDistribution<? extends Number> distribution;

    public UnivariateRandomVariable(UnivariateDistribution<? extends Number> distribution, Random random) {
        this(distribution, random, 10000);
    }

    public UnivariateRandomVariable(UnivariateDistribution<? extends Number> distribution, Random random, int numSamples) {
        this.setDistribution(distribution);
        this.setRandom(random);
        this.setNumSamples(numSamples);
    }

    @Override
    public UnivariateRandomVariable clone() {
        return (UnivariateRandomVariable)super.clone();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof RandomVariable) {
            return this.equals((RandomVariable)obj, 0.95);
        }
        return false;
    }

    @Override
    public boolean equals(RandomVariable<Number> other, double effectiveZero) {
        ArrayList data2;
        double pValue = 1.0 - effectiveZero;
        KolmogorovSmirnovConfidence kstest = new KolmogorovSmirnovConfidence();
        ArrayList<Number> data1 = this.sample(this.random, this.numSamples);
        KolmogorovSmirnovConfidence.Statistic stat = kstest.evaluateNullHypothesis((Collection<? extends Number>)data1, data2 = other.sample(this.random, this.numSamples));
        return stat.getNullHypothesisProbability() >= pValue;
    }

    @Override
    public void plusEquals(RandomVariable<Number> other) {
        ArrayList<Number> X = this.sample(this.getRandom(), this.getNumSamples());
        ArrayList Y = other.sample(this.getRandom(), this.getNumSamples());
        ArrayList<Double> Z = new ArrayList<Double>(this.getNumSamples());
        for (int n = 0; n < this.getNumSamples(); ++n) {
            Z.add(X.get(n).doubleValue() + ((Number)Y.get(n)).doubleValue());
        }
        this.setDistribution(new ScalarDataDistribution.PMF((Collection<? extends Number>)Z));
    }

    @Override
    public void minusEquals(RandomVariable<Number> other) {
        ArrayList<Number> X = this.sample(this.getRandom(), this.getNumSamples());
        ArrayList Y = other.sample(this.getRandom(), this.getNumSamples());
        ArrayList<Double> Z = new ArrayList<Double>(this.getNumSamples());
        for (int n = 0; n < this.getNumSamples(); ++n) {
            Z.add(X.get(n).doubleValue() - ((Number)Y.get(n)).doubleValue());
        }
        this.setDistribution(new ScalarDataDistribution.PMF((Collection<? extends Number>)Z));
    }

    @Override
    public void dotTimesEquals(RandomVariable<Number> other) {
        ArrayList<Number> X = this.sample(this.getRandom(), this.getNumSamples());
        ArrayList Y = other.sample(this.getRandom(), this.getNumSamples());
        ArrayList<Double> Z = new ArrayList<Double>(this.getNumSamples());
        for (int n = 0; n < this.getNumSamples(); ++n) {
            Z.add(X.get(n).doubleValue() * ((Number)Y.get(n)).doubleValue());
        }
        this.setDistribution(new ScalarDataDistribution.PMF((Collection<? extends Number>)Z));
    }

    @Override
    public void scaleEquals(double scaleFactor) {
        ArrayList<Number> X = this.sample(this.getRandom(), this.getNumSamples());
        ArrayList<Double> Z = new ArrayList<Double>(this.getNumSamples());
        for (int n = 0; n < this.getNumSamples(); ++n) {
            Z.add(X.get(n).doubleValue() * scaleFactor);
        }
        this.setDistribution(new ScalarDataDistribution.PMF((Collection<? extends Number>)Z));
    }

    @Override
    public boolean isZero(double effectiveZero) {
        UnivariateRandomVariable zero = this.clone();
        zero.zero();
        return this.equals(zero, effectiveZero);
    }

    @Override
    public ArrayList<Number> sample(Random random, int numSamples) {
        return new ArrayList<Number>(this.getDistribution().sample(random, numSamples));
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumSamples(int numSamples) {
        if (numSamples <= 0) {
            throw new IllegalArgumentException("numSamples must be >= 1");
        }
        this.numSamples = numSamples;
    }

    @Override
    public Random getRandom() {
        return this.random;
    }

    @Override
    public void setRandom(Random random) {
        this.random = random;
    }

    public UnivariateDistribution<? extends Number> getDistribution() {
        return this.distribution;
    }

    public void setDistribution(UnivariateDistribution<? extends Number> distribution) {
        this.distribution = distribution;
    }

    @Override
    public Number getMean() {
        return (Number)this.getDistribution().getMean();
    }

    @Override
    public double getVariance() {
        return this.getDistribution().getVariance();
    }

    @Override
    public Double getMinSupport() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public Double getMaxSupport() {
        return Double.POSITIVE_INFINITY;
    }

    @PublicationReference(author={"Wikipedia"}, title="Standard error (statistics)", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Standard_error_(statistics)")
    public ConfidenceInterval getSamplingError(double confidence) {
        return GaussianConfidence.computeConfidenceInterval(this, this.numSamples, confidence);
    }

    @Override
    public CumulativeDistributionFunction<Number> getCDF() {
        return this.getDistribution().getCDF();
    }
}

