/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.bayesian;

import gov.sandia.cognition.learning.algorithm.AbstractBatchAndIncrementalLearner;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.statistics.bayesian.RecursiveBayesianEstimator;
import gov.sandia.cognition.statistics.distribution.MultivariateGaussian;
import gov.sandia.cognition.util.ObjectUtil;

public abstract class AbstractKalmanFilter
extends AbstractBatchAndIncrementalLearner<Vector, MultivariateGaussian>
implements RecursiveBayesianEstimator<Vector, Vector, MultivariateGaussian> {
    protected Vector currentInput;
    protected Matrix modelCovariance;
    protected Matrix measurementCovariance;

    public AbstractKalmanFilter(Vector currentInput, Matrix modelCovariance, Matrix measurementCovariance) {
        this.currentInput = currentInput;
        this.modelCovariance = modelCovariance;
        this.measurementCovariance = measurementCovariance;
    }

    @Override
    public AbstractKalmanFilter clone() {
        AbstractKalmanFilter clone = (AbstractKalmanFilter)super.clone();
        clone.setCurrentInput(ObjectUtil.cloneSafe(this.getCurrentInput()));
        clone.setMeasurementCovariance(ObjectUtil.cloneSafe(this.getMeasurementCovariance()));
        clone.setModelCovariance(ObjectUtil.cloneSafe(this.getModelCovariance()));
        return clone;
    }

    public abstract void predict(MultivariateGaussian var1);

    public Matrix computePredictionCovariance(Matrix A, Matrix beliefCovariance) {
        Matrix P = beliefCovariance;
        P = A.times(P).times(A.transpose());
        P.plusEquals(this.modelCovariance);
        return P;
    }

    public abstract void measure(MultivariateGaussian var1, Vector var2);

    public void computeMeasurementBelief(MultivariateGaussian belief, Vector innovation, Matrix C) {
        Matrix Ct = C.transpose();
        Matrix P = belief.getCovariance();
        Vector xpred = belief.getMean();
        Matrix PCt = P.times(Ct);
        Matrix innovationCovariance = C.times(PCt);
        innovationCovariance.plusEquals(this.measurementCovariance);
        Matrix kalmanGain = PCt.times(innovationCovariance.inverse());
        xpred.plusEquals(kalmanGain.times(innovation));
        P.minusEquals(kalmanGain.times(C).times(P));
        belief.setMean(xpred);
        belief.setCovariance(P);
    }

    @Override
    public void update(MultivariateGaussian belief, Vector observation) {
        this.predict(belief);
        if (observation != null) {
            this.measure(belief, observation);
        }
    }

    public Matrix getModelCovariance() {
        return this.modelCovariance;
    }

    public void setModelCovariance(Matrix modelCovariance) {
        this.modelCovariance = modelCovariance;
    }

    public Vector getCurrentInput() {
        return this.currentInput;
    }

    public void setCurrentInput(Vector currentInput) {
        this.currentInput = currentInput;
    }

    public Matrix getMeasurementCovariance() {
        return this.measurementCovariance;
    }

    public void setMeasurementCovariance(Matrix measurementCovariance) {
        this.measurementCovariance = measurementCovariance;
    }
}

