/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.bayesian;

import gov.sandia.cognition.statistics.ClosedFormDistribution;
import gov.sandia.cognition.statistics.DefaultDistributionParameter;
import gov.sandia.cognition.statistics.Distribution;
import gov.sandia.cognition.statistics.bayesian.BayesianParameter;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.Random;

public class DefaultBayesianParameter<ParameterType, ConditionalType extends ClosedFormDistribution<?>, PriorType extends Distribution<ParameterType>>
extends DefaultDistributionParameter<ParameterType, ConditionalType>
implements BayesianParameter<ParameterType, ConditionalType, PriorType> {
    private PriorType parameterPrior;

    public DefaultBayesianParameter(ConditionalType conditionalDistribution, String parameterName) {
        this(conditionalDistribution, parameterName, null);
    }

    public DefaultBayesianParameter(ConditionalType conditionalDistribution, String parameterName, PriorType parameterPrior) {
        super(conditionalDistribution, parameterName);
        this.setParameterPrior(parameterPrior);
    }

    @Override
    public DefaultBayesianParameter<ParameterType, ConditionalType, PriorType> clone() {
        DefaultBayesianParameter clone = (DefaultBayesianParameter)super.clone();
        clone.setParameterPrior((Distribution)ObjectUtil.cloneSafe(this.getParameterPrior()));
        clone.setName(this.getName());
        return clone;
    }

    @Override
    public PriorType getParameterPrior() {
        return this.parameterPrior;
    }

    public void setParameterPrior(PriorType parameterPrior) {
        this.parameterPrior = parameterPrior;
    }

    @Override
    public void updateConditionalDistribution(Random random) {
        Object parameter = this.parameterPrior.sample(random);
        this.setValue(parameter);
    }

    public static <ParameterType, ConditionalType extends ClosedFormDistribution<?>, PriorType extends Distribution<ParameterType>> DefaultBayesianParameter<ParameterType, ConditionalType, PriorType> create(ConditionalType conditionalDistribution, String parameterName, PriorType parameterPrior) {
        return new DefaultBayesianParameter<ParameterType, ConditionalType, PriorType>(conditionalDistribution, parameterName, parameterPrior);
    }
}

