/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.bayesian;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.statistics.ComputableDistribution;
import gov.sandia.cognition.statistics.PointMassDistribution;
import gov.sandia.cognition.statistics.ProbabilityFunction;
import gov.sandia.cognition.statistics.bayesian.BayesianEstimator;
import gov.sandia.cognition.statistics.bayesian.BayesianParameter;
import gov.sandia.cognition.statistics.bayesian.BayesianUtil;
import gov.sandia.cognition.statistics.distribution.MapBasedPointMassDistribution;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.AbstractRandomized;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.DefaultWeightedValue;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Importance Sampling", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Importance_sampling")
public class ImportanceSampling<ObservationType, ParameterType>
extends AbstractRandomized
implements BayesianEstimator<ObservationType, ParameterType, PointMassDistribution<ParameterType>> {
    public static final int DEFAULT_NUM_SAMPLES = 1000;
    protected Updater<ObservationType, ParameterType> updater;
    private int numSamples;

    public ImportanceSampling() {
        super(null);
        this.setNumSamples(this.numSamples);
        this.numSamples = 1000;
    }

    @Override
    public ImportanceSampling<ObservationType, ParameterType> clone() {
        ImportanceSampling clone = (ImportanceSampling)super.clone();
        clone.setUpdater(ObjectUtil.cloneSafe(this.getUpdater()));
        return clone;
    }

    @Override
    public PointMassDistribution<ParameterType> learn(Collection<? extends ObservationType> data) {
        ArrayList<DefaultWeightedValue<ParameterType>> weightedSamples = new ArrayList<DefaultWeightedValue<ParameterType>>(this.getNumSamples());
        double maxWeight = Double.NEGATIVE_INFINITY;
        for (int n = 0; n < this.getNumSamples(); ++n) {
            double lq;
            ParameterType parameter = this.getUpdater().makeProposal(this.random);
            double d = this.getUpdater().computeLogLikelihood(parameter, data);
            double weight = d - (lq = this.getUpdater().computeLogImportanceValue(parameter));
            if (maxWeight < weight) {
                maxWeight = weight;
            }
            weightedSamples.add(new DefaultWeightedValue<ParameterType>(parameter, weight));
        }
        maxWeight -= Math.log(Double.MAX_VALUE / (double)this.getNumSamples() / 2.0);
        MapBasedPointMassDistribution retval = new MapBasedPointMassDistribution(this.getNumSamples());
        for (DefaultWeightedValue defaultWeightedValue : weightedSamples) {
            double mass = Math.exp(defaultWeightedValue.getWeight() - maxWeight);
            retval.add(defaultWeightedValue.getValue(), mass);
        }
        return retval;
    }

    public Updater<ObservationType, ParameterType> getUpdater() {
        return this.updater;
    }

    public void setUpdater(Updater<ObservationType, ParameterType> updater) {
        this.updater = updater;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumSamples(int numSamples) {
        this.numSamples = numSamples;
    }

    public static class DefaultUpdater<ObservationType, ParameterType>
    extends AbstractCloneableSerializable
    implements Updater<ObservationType, ParameterType> {
        protected BayesianParameter<ParameterType, ? extends ProbabilityFunction<ObservationType>, ? extends ProbabilityFunction<ParameterType>> conjuctive;

        public DefaultUpdater() {
            this(null);
        }

        public DefaultUpdater(BayesianParameter<ParameterType, ? extends ProbabilityFunction<ObservationType>, ? extends ProbabilityFunction<ParameterType>> conjuctive) {
            this.setConjuctive(conjuctive);
        }

        @Override
        public double computeLogLikelihood(ParameterType parameter, Iterable<? extends ObservationType> data) {
            this.conjuctive.setValue(parameter);
            return BayesianUtil.logLikelihood((ComputableDistribution)this.conjuctive.getConditionalDistribution(), data);
        }

        @Override
        public double computeLogImportanceValue(ParameterType parameter) {
            return this.conjuctive.getParameterPrior().logEvaluate(parameter);
        }

        @Override
        public ParameterType makeProposal(Random random) {
            return (ParameterType)this.conjuctive.getParameterPrior().sample(random);
        }

        public BayesianParameter<ParameterType, ? extends ProbabilityFunction<ObservationType>, ? extends ProbabilityFunction<ParameterType>> getConjuctive() {
            return this.conjuctive;
        }

        public void setConjuctive(BayesianParameter<ParameterType, ? extends ProbabilityFunction<ObservationType>, ? extends ProbabilityFunction<ParameterType>> conjuctive) {
            this.conjuctive = conjuctive;
        }
    }

    public static interface Updater<ObservationType, ParameterType>
    extends CloneableSerializable {
        public double computeLogLikelihood(ParameterType var1, Iterable<? extends ObservationType> var2);

        public double computeLogImportanceValue(ParameterType var1);

        public ParameterType makeProposal(Random var1);
    }
}

