/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.bayesian.conjugate;

import gov.sandia.cognition.statistics.bayesian.AbstractBayesianParameter;
import gov.sandia.cognition.statistics.bayesian.BayesianParameter;
import gov.sandia.cognition.statistics.bayesian.conjugate.AbstractConjugatePriorBayesianEstimator;
import gov.sandia.cognition.statistics.bayesian.conjugate.ConjugatePriorBayesianEstimatorPredictor;
import gov.sandia.cognition.statistics.distribution.BetaBinomialDistribution;
import gov.sandia.cognition.statistics.distribution.BetaDistribution;
import gov.sandia.cognition.statistics.distribution.BinomialDistribution;

public class BinomialBayesianEstimator
extends AbstractConjugatePriorBayesianEstimator<Number, Double, BinomialDistribution, BetaDistribution>
implements ConjugatePriorBayesianEstimatorPredictor<Number, Double, BinomialDistribution, BetaDistribution> {
    public static final int DEFAULT_N = 1;

    public BinomialBayesianEstimator() {
        this(1);
    }

    public BinomialBayesianEstimator(int n) {
        this(n, new BetaDistribution(1.0, 1.0));
    }

    public BinomialBayesianEstimator(int n, BetaDistribution prior) {
        this(new BinomialDistribution(n, 0.5), prior);
    }

    public BinomialBayesianEstimator(BinomialDistribution conditional, BetaDistribution prior) {
        this(new Parameter(conditional, prior));
    }

    protected BinomialBayesianEstimator(BayesianParameter<Double, BinomialDistribution, BetaDistribution> parameter) {
        super(parameter);
    }

    public Parameter createParameter(BinomialDistribution conditional, BetaDistribution prior) {
        return new Parameter(conditional, prior);
    }

    @Override
    public BinomialBayesianEstimator clone() {
        return (BinomialBayesianEstimator)super.clone();
    }

    @Override
    public void update(BetaDistribution target, Number data) {
        int n = this.getN();
        int success = data.intValue();
        int failure = n - success;
        double alpha = target.getAlpha();
        double beta = target.getBeta();
        target.setAlpha(alpha += (double)success);
        target.setBeta(beta += (double)failure);
    }

    @Override
    public double computeEquivalentSampleSize(BetaDistribution belief) {
        double alpha = belief.getAlpha();
        double beta = belief.getBeta();
        return (alpha + beta) / (double)this.getN() + 1.0;
    }

    public BetaBinomialDistribution createPredictiveDistribution(BetaDistribution posterior) {
        return new BetaBinomialDistribution(this.getN(), posterior.getAlpha(), posterior.getBeta());
    }

    public int getN() {
        return ((BinomialDistribution)this.parameter.getConditionalDistribution()).getN();
    }

    public void setN(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n must be > 0");
        }
        ((BinomialDistribution)this.parameter.getConditionalDistribution()).setN(n);
    }

    public static class Parameter
    extends AbstractBayesianParameter<Double, BinomialDistribution, BetaDistribution> {
        public static final String NAME = "p";

        public Parameter(BinomialDistribution conditional, BetaDistribution prior) {
            super(conditional, NAME, prior);
        }

        @Override
        public void setValue(Double value) {
            ((BinomialDistribution)this.conditionalDistribution).setP(value);
        }

        @Override
        public Double getValue() {
            return ((BinomialDistribution)this.conditionalDistribution).getP();
        }
    }
}

