/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.bayesian.conjugate;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.statistics.bayesian.AbstractBayesianParameter;
import gov.sandia.cognition.statistics.bayesian.BayesianParameter;
import gov.sandia.cognition.statistics.bayesian.conjugate.AbstractConjugatePriorBayesianEstimator;
import gov.sandia.cognition.statistics.bayesian.conjugate.ConjugatePriorBayesianEstimatorPredictor;
import gov.sandia.cognition.statistics.distribution.ExponentialDistribution;
import gov.sandia.cognition.statistics.distribution.GammaDistribution;
import gov.sandia.cognition.statistics.distribution.ParetoDistribution;

@PublicationReferences(references={@PublicationReference(author={"Wikipedia"}, title="Conjugate Prior", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Conjugate_prior"), @PublicationReference(author={"Byron J. Gajewski", "Stephen D. Simon", "Susan E. Carlson"}, title="Predicting accrual in clinical trials with Bayesian posterior predictive distributions", type=PublicationType.Journal, year=2008, publication="Statistics in Medicine", notes={"They derive the predictive posterior for an inverse gamma, but we're using a gamma, so we have to invert the scale parameter."})})
public class ExponentialBayesianEstimator
extends AbstractConjugatePriorBayesianEstimator<Double, Double, ExponentialDistribution, GammaDistribution>
implements ConjugatePriorBayesianEstimatorPredictor<Double, Double, ExponentialDistribution, GammaDistribution> {
    public ExponentialBayesianEstimator() {
        this(new GammaDistribution(1.0, 1.0));
    }

    public ExponentialBayesianEstimator(GammaDistribution prior) {
        this(new ExponentialDistribution(), prior);
    }

    public ExponentialBayesianEstimator(ExponentialDistribution conditional, GammaDistribution prior) {
        this(new Parameter(conditional, prior));
    }

    protected ExponentialBayesianEstimator(BayesianParameter<Double, ExponentialDistribution, GammaDistribution> parameter) {
        super(parameter);
    }

    public Parameter createParameter(ExponentialDistribution conditional, GammaDistribution prior) {
        return new Parameter(conditional, prior);
    }

    @Override
    public void update(GammaDistribution belief, Double data) {
        double alpha = belief.getShape();
        double beta = 1.0 / belief.getScale();
        double theta = 1.0 / (beta += data.doubleValue());
        belief.setShape(alpha += 1.0);
        belief.setScale(theta);
    }

    @Override
    public double computeEquivalentSampleSize(GammaDistribution belief) {
        return belief.getShape();
    }

    public ParetoDistribution createPredictiveDistribution(GammaDistribution posterior) {
        return new ParetoDistribution(posterior.getShape(), 1.0 / posterior.getScale(), 1.0 / posterior.getScale());
    }

    public static class Parameter
    extends AbstractBayesianParameter<Double, ExponentialDistribution, GammaDistribution> {
        public static final String NAME = "rate";

        public Parameter(ExponentialDistribution conditional, GammaDistribution prior) {
            super(conditional, NAME, prior);
        }

        @Override
        public void setValue(Double value) {
            ((ExponentialDistribution)this.conditionalDistribution).setRate(value);
        }

        @Override
        public Double getValue() {
            return ((ExponentialDistribution)this.conditionalDistribution).getRate();
        }
    }
}

