/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.bayesian.conjugate;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.statistics.bayesian.AbstractBayesianParameter;
import gov.sandia.cognition.statistics.bayesian.BayesianParameter;
import gov.sandia.cognition.statistics.bayesian.conjugate.AbstractConjugatePriorBayesianEstimator;
import gov.sandia.cognition.statistics.bayesian.conjugate.ConjugatePriorBayesianEstimatorPredictor;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;

@PublicationReference(author={"William M. Bolstad"}, title="Introduction to Bayesian Statistics: Second Edition", type=PublicationType.Book, year=2007, pages={208})
public class UnivariateGaussianMeanBayesianEstimator
extends AbstractConjugatePriorBayesianEstimator<Double, Double, UnivariateGaussian, UnivariateGaussian>
implements ConjugatePriorBayesianEstimatorPredictor<Double, Double, UnivariateGaussian, UnivariateGaussian> {
    public static final double DEFAULT_KNOWN_VARIANCE = 1.0;

    public UnivariateGaussianMeanBayesianEstimator() {
        this(1.0);
    }

    public UnivariateGaussianMeanBayesianEstimator(double knownVariance) {
        this(knownVariance, new UnivariateGaussian(0.0, 1.0));
    }

    public UnivariateGaussianMeanBayesianEstimator(double knownVariance, UnivariateGaussian belief) {
        this(new UnivariateGaussian(0.0, knownVariance), belief);
    }

    public UnivariateGaussianMeanBayesianEstimator(UnivariateGaussian conditional, UnivariateGaussian prior) {
        this(new Parameter(conditional, prior));
    }

    protected UnivariateGaussianMeanBayesianEstimator(BayesianParameter<Double, UnivariateGaussian, UnivariateGaussian> parameter) {
        super(parameter);
    }

    public Parameter createParameter(UnivariateGaussian conditional, UnivariateGaussian prior) {
        return new Parameter(conditional, prior);
    }

    public double getKnownVariance() {
        return ((UnivariateGaussian)this.parameter.getConditionalDistribution()).getVariance();
    }

    public void setKnownVariance(double knownVariance) {
        ((UnivariateGaussian)this.parameter.getConditionalDistribution()).setVariance(knownVariance);
    }

    @Override
    public void update(UnivariateGaussian updater, Double data) {
        double s2 = this.getKnownVariance();
        double s2hat = updater.getVariance();
        double m = updater.getMean();
        double y = data;
        double mhat = (s2 * m + s2hat * y) / (s2 + s2hat);
        double v2hat = s2 * s2hat / (s2 + s2hat);
        updater.setMean(mhat);
        updater.setVariance(v2hat);
    }

    @Override
    public double computeEquivalentSampleSize(UnivariateGaussian belief) {
        return this.getKnownVariance() / belief.getVariance();
    }

    public UnivariateGaussian createPredictiveDistribution(UnivariateGaussian posterior) {
        UnivariateGaussian conditional = new UnivariateGaussian(0.0, this.getKnownVariance());
        return posterior.convolve(conditional);
    }

    public static class Parameter
    extends AbstractBayesianParameter<Double, UnivariateGaussian, UnivariateGaussian> {
        public static final String NAME = "mean";

        public Parameter(UnivariateGaussian conditional, UnivariateGaussian prior) {
            super(conditional, NAME, prior);
        }

        @Override
        public void setValue(Double value) {
            ((UnivariateGaussian)this.conditionalDistribution).setMean(value);
        }

        @Override
        public Double getValue() {
            return ((UnivariateGaussian)this.conditionalDistribution).getMean();
        }
    }
}

