/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.ProbabilityUtil;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.AbstractClosedFormUnivariateDistribution;
import gov.sandia.cognition.statistics.ClosedFormCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.ClosedFormDiscreteUnivariateDistribution;
import gov.sandia.cognition.statistics.ProbabilityMassFunction;
import gov.sandia.cognition.statistics.ProbabilityMassFunctionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Bernoulli distribution", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Bernoulli_distribution")
public class BernoulliDistribution
extends AbstractClosedFormUnivariateDistribution<Number>
implements ClosedFormDiscreteUnivariateDistribution<Number> {
    public static final double DEFAULT_P = 0.5;
    private double p;

    public BernoulliDistribution() {
        this(0.5);
    }

    public BernoulliDistribution(double p) {
        this.setP(p);
    }

    public BernoulliDistribution(BernoulliDistribution other) {
        this(other.getP());
    }

    @Override
    public Double getMean() {
        return this.getP();
    }

    @Override
    public Integer getMinSupport() {
        return 0;
    }

    @Override
    public Integer getMaxSupport() {
        return 1;
    }

    @Override
    public ArrayList<Integer> sample(Random random, int numSamples) {
        ArrayList<Integer> samples = new ArrayList<Integer>(numSamples);
        for (int i = 0; i < numSamples; ++i) {
            double x = random.nextDouble();
            if (x < this.p) {
                samples.add(1);
                continue;
            }
            samples.add(0);
        }
        return samples;
    }

    @Override
    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(this.getP());
    }

    @Override
    public void convertFromVector(Vector parameters) {
        if (parameters.getDimensionality() != 1) {
            throw new IllegalArgumentException("parameter dimension must be 1");
        }
        this.setP(parameters.getElement(0));
    }

    @Override
    public double getVariance() {
        return this.getP() * (1.0 - this.getP());
    }

    @Override
    public List<Integer> getDomain() {
        return Arrays.asList(0, 1);
    }

    @Override
    public int getDomainSize() {
        return 2;
    }

    public double getP() {
        return this.p;
    }

    public void setP(double p) {
        ProbabilityUtil.assertIsProbability(p);
        this.p = p;
    }

    public CDF getCDF() {
        return new CDF(this);
    }

    public PMF getProbabilityFunction() {
        return new PMF(this);
    }

    public String toString() {
        return "p = " + this.getP();
    }

    public static class CDF
    extends BernoulliDistribution
    implements ClosedFormCumulativeDistributionFunction<Number> {
        public CDF() {
        }

        public CDF(double p) {
            super(p);
        }

        public CDF(BernoulliDistribution other) {
            super(other);
        }

        @Override
        public Double evaluate(Number input) {
            if (input.intValue() < 0) {
                return 0.0;
            }
            if (input.intValue() <= 0) {
                return 1.0 - this.getP();
            }
            return 1.0;
        }

        @Override
        public CDF getCDF() {
            return this;
        }
    }

    public static class PMF
    extends BernoulliDistribution
    implements ProbabilityMassFunction<Number> {
        public PMF() {
        }

        public PMF(double p) {
            super(p);
        }

        public PMF(BernoulliDistribution other) {
            super(other);
        }

        @Override
        public double getEntropy() {
            return ProbabilityMassFunctionUtil.getEntropy(this);
        }

        @Override
        public Double evaluate(Number input) {
            if (input.intValue() == 0) {
                return 1.0 - this.getP();
            }
            if (input.intValue() == 1) {
                return this.getP();
            }
            return 0.0;
        }

        @Override
        public double logEvaluate(Number input) {
            return Math.log(this.evaluate(input));
        }

        @Override
        public PMF getProbabilityFunction() {
            return this;
        }
    }
}

