/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.IntegerCollection;
import gov.sandia.cognition.math.MathUtil;
import gov.sandia.cognition.math.UnivariateStatisticsUtil;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.AbstractClosedFormUnivariateDistribution;
import gov.sandia.cognition.statistics.ClosedFormCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.ClosedFormDiscreteUnivariateDistribution;
import gov.sandia.cognition.statistics.DistributionEstimator;
import gov.sandia.cognition.statistics.EstimableDistribution;
import gov.sandia.cognition.statistics.ProbabilityMassFunction;
import gov.sandia.cognition.statistics.ProbabilityMassFunctionUtil;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

@PublicationReference(author={"Eric Weisstein"}, title="Beta Binomial Distribution", type=PublicationType.WebPage, year=2010, url="http://mathworld.wolfram.com/BetaBinomialDistribution.html")
public class BetaBinomialDistribution
extends AbstractClosedFormUnivariateDistribution<Number>
implements ClosedFormDiscreteUnivariateDistribution<Number>,
EstimableDistribution<Number, BetaBinomialDistribution> {
    public static final double DEFAULT_SHAPE = 1.0;
    public static final double DEFAULT_SCALE = 1.0;
    public static final int DEFAULT_N = 1;
    protected int n;
    protected double shape;
    protected double scale;

    public BetaBinomialDistribution() {
        this(1, 1.0, 1.0);
    }

    public BetaBinomialDistribution(int n, double shape, double scale) {
        this.setN(n);
        this.setShape(shape);
        this.setScale(scale);
    }

    public BetaBinomialDistribution(BetaBinomialDistribution other) {
        this(other.getN(), other.getShape(), other.getScale());
    }

    @Override
    public BetaBinomialDistribution clone() {
        return (BetaBinomialDistribution)super.clone();
    }

    public double getShape() {
        return this.shape;
    }

    public void setShape(double shape) {
        if (shape <= 0.0) {
            throw new IllegalArgumentException("shape must be > 0.0");
        }
        this.shape = shape;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("scale must be > 0.0");
        }
        this.scale = scale;
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("n must be > 0");
        }
        this.n = n;
    }

    @Override
    public Number getMean() {
        return (double)this.n * this.shape / (this.shape + this.scale);
    }

    @Override
    public ArrayList<? extends Number> sample(Random random, int numSamples) {
        return ProbabilityMassFunctionUtil.sample(this.getProbabilityFunction(), random, numSamples);
    }

    public CDF getCDF() {
        return new CDF(this);
    }

    @Override
    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(this.n, this.shape, this.scale);
    }

    @Override
    public void convertFromVector(Vector parameters) {
        parameters.assertDimensionalityEquals(3);
        this.setN((int)parameters.getElement(0));
        this.setShape(parameters.getElement(1));
        this.setScale(parameters.getElement(2));
    }

    @Override
    public Integer getMinSupport() {
        return 0;
    }

    @Override
    public Integer getMaxSupport() {
        return this.n;
    }

    @Override
    public double getVariance() {
        double ss = this.shape + this.scale;
        double numer = (double)this.n * this.shape * this.scale * (ss + (double)this.n);
        double denom = ss * ss * (ss + 1.0);
        return numer / denom;
    }

    @Override
    public Collection<Integer> getDomain() {
        return new IntegerCollection(0, (int)Math.ceil(this.n));
    }

    @Override
    public int getDomainSize() {
        return (int)Math.ceil(this.n) + 1;
    }

    public PMF getProbabilityFunction() {
        return new PMF(this);
    }

    public MomentMatchingEstimator getEstimator() {
        return new MomentMatchingEstimator();
    }

    @PublicationReference(author={"Ram C. Tripathi", "Ramesh C. Gupta", "John Gurland"}, title="Estimation of parameters in the beta binomial model", type=PublicationType.Journal, publication="Annals of the Institute of Statistical Mathematics", year=1994, pages={317, 331}, notes={"Equation 2.11"})
    public static class MomentMatchingEstimator
    extends AbstractCloneableSerializable
    implements DistributionEstimator<Number, BetaBinomialDistribution> {
        @Override
        public BetaBinomialDistribution learn(Collection<? extends Number> data) {
            Pair<Double, Double> pair = UnivariateStatisticsUtil.computeMeanAndVariance(data);
            double mean = pair.getFirst();
            double max = UnivariateStatisticsUtil.computeMaximum(data);
            int N = (int)Math.ceil(max);
            double eta = 0.0;
            double smooth = 1.0;
            for (Number number : data) {
                double numPositive = number.doubleValue() + smooth;
                double numNegative = (double)N - number.doubleValue() + smooth;
                double e = numPositive / numNegative;
                eta += e;
            }
            double denom = (double)N * mean - ((double)N - mean) * (eta /= (double)N);
            double alpha = Math.abs((double)(N - 1) * eta * mean / denom);
            double beta = Math.abs((double)(N - 1) * ((double)N - mean) * eta / denom);
            PMF distribution = new PMF(N, alpha, beta);
            System.out.println("Mean: " + ((Number)distribution.getMean()).doubleValue() + ", Variance: " + distribution.getVariance());
            return distribution;
        }

        public static PMF learn(int N, double mean, double variance) {
            double denom = (double)N * (variance / mean - mean - 1.0) + mean;
            double alpha = Math.abs(((double)N * mean - variance) / denom);
            double beta = Math.abs(((double)N - mean) * ((double)N - variance / mean) / denom);
            System.out.println("N = " + N + ", alpha = " + alpha + ", beta = " + beta);
            PMF distribution = new PMF(N, alpha, beta);
            System.out.println("Mean: " + ((Number)distribution.getMean()).doubleValue() + ", Variance: " + distribution.getVariance());
            return new PMF(N, alpha, beta);
        }
    }

    public static class CDF
    extends BetaBinomialDistribution
    implements ClosedFormCumulativeDistributionFunction<Number> {
        public CDF() {
        }

        public CDF(int n, double shape, double scale) {
            super(n, shape, scale);
        }

        public CDF(BetaBinomialDistribution other) {
            super(other);
        }

        @Override
        public Double evaluate(Number input) {
            return ProbabilityMassFunctionUtil.computeCumulativeValue(input.intValue(), this);
        }

        @Override
        public CDF getCDF() {
            return this;
        }
    }

    public static class PMF
    extends BetaBinomialDistribution
    implements ProbabilityMassFunction<Number> {
        public PMF() {
        }

        public PMF(int n, double shape, double scale) {
            super(n, shape, scale);
        }

        public PMF(BetaBinomialDistribution other) {
            super(other);
        }

        @Override
        public PMF getProbabilityFunction() {
            return this;
        }

        @Override
        public Double evaluate(Number input) {
            return Math.exp(this.logEvaluate(input));
        }

        @Override
        public double logEvaluate(Number input) {
            if (input.doubleValue() < 0.0) {
                return Math.log(0.0);
            }
            if (input.doubleValue() > (double)this.n) {
                return Math.log(0.0);
            }
            int x = input.intValue();
            double logSum = 0.0;
            logSum += MathUtil.logBinomialCoefficient(this.n, x);
            logSum -= MathUtil.logBetaFunction(this.shape, this.scale);
            return logSum += MathUtil.logBetaFunction(this.shape + (double)x, (double)this.n + this.scale - (double)x);
        }

        @Override
        public double getEntropy() {
            return ProbabilityMassFunctionUtil.getEntropy(this);
        }
    }
}

