/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.MathUtil;
import gov.sandia.cognition.math.UnivariateStatisticsUtil;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.AbstractClosedFormSmoothUnivariateDistribution;
import gov.sandia.cognition.statistics.DistributionEstimator;
import gov.sandia.cognition.statistics.DistributionWeightedEstimator;
import gov.sandia.cognition.statistics.EstimableDistribution;
import gov.sandia.cognition.statistics.SmoothCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.UnivariateProbabilityDensityFunction;
import gov.sandia.cognition.statistics.distribution.GammaDistribution;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.Pair;
import gov.sandia.cognition.util.WeightedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Beta distribution", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Beta_distribution")
public class BetaDistribution
extends AbstractClosedFormSmoothUnivariateDistribution
implements EstimableDistribution<Double, BetaDistribution> {
    public static final double DEFAULT_ALPHA = 2.0;
    public static final double DEFAULT_BETA = 2.0;
    private double alpha;
    private double beta;

    public BetaDistribution() {
        this(2.0, 2.0);
    }

    public BetaDistribution(double alpha, double beta) {
        this.setAlpha(alpha);
        this.setBeta(beta);
    }

    public BetaDistribution(BetaDistribution other) {
        this(other.getAlpha(), other.getBeta());
    }

    @Override
    public BetaDistribution clone() {
        return (BetaDistribution)super.clone();
    }

    @Override
    public Double getMean() {
        return this.getAlpha() / (this.getAlpha() + this.getBeta());
    }

    @Override
    public double getVariance() {
        double numerator = this.getAlpha() * this.getBeta();
        double apb = this.getAlpha() + this.getBeta();
        double denominator = apb * apb * (apb + 1.0);
        return numerator / denominator;
    }

    @Override
    public ArrayList<Double> sample(Random random, int numSamples) {
        ArrayList<Double> samples = new ArrayList<Double>(numSamples);
        ArrayList<Double> Xs = GammaDistribution.sample(this.alpha, 1.0, random, numSamples);
        ArrayList<Double> Ys = GammaDistribution.sample(this.beta, 1.0, random, numSamples);
        for (int n = 0; n < numSamples; ++n) {
            double x = Xs.get(n);
            double y = Ys.get(n);
            samples.add(x / (x + y));
        }
        return samples;
    }

    @Override
    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(this.getAlpha(), this.getBeta());
    }

    @Override
    public void convertFromVector(Vector parameters) {
        if (parameters.getDimensionality() != 2) {
            throw new IllegalArgumentException("Expecting 2-dimensional parameter Vector!");
        }
        this.setAlpha(parameters.getElement(0));
        this.setBeta(parameters.getElement(1));
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("Alpha must be > 0.0");
        }
        this.alpha = alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public void setBeta(double beta) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("Beta must be > 0.0");
        }
        this.beta = beta;
    }

    @Override
    public CDF getCDF() {
        return new CDF(this);
    }

    @Override
    public PDF getProbabilityFunction() {
        return new PDF(this);
    }

    @Override
    public Double getMinSupport() {
        return 0.0;
    }

    @Override
    public Double getMaxSupport() {
        return 1.0;
    }

    public MomentMatchingEstimator getEstimator() {
        return new MomentMatchingEstimator();
    }

    public static class CDF
    extends BetaDistribution
    implements SmoothCumulativeDistributionFunction {
        public CDF() {
        }

        public CDF(double alpha, double beta) {
            super(alpha, beta);
        }

        public CDF(BetaDistribution other) {
            super(other);
        }

        @Override
        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        @Override
        public double evaluate(double input) {
            return CDF.evaluate(input, this.getAlpha(), this.getBeta());
        }

        public static double evaluate(double x, double alpha, double beta) {
            double p = x <= 0.0 ? 0.0 : (x >= 1.0 ? 1.0 : MathUtil.regularizedIncompleteBetaFunction(alpha, beta, x));
            return p;
        }

        @Override
        public CDF getCDF() {
            return this;
        }

        @Override
        public PDF getDerivative() {
            return this.getProbabilityFunction();
        }

        @Override
        public Double differentiate(Double input) {
            return this.getDerivative().evaluate(input);
        }
    }

    public static class PDF
    extends BetaDistribution
    implements UnivariateProbabilityDensityFunction {
        public PDF() {
        }

        public PDF(double alpha, double beta) {
            super(alpha, beta);
        }

        public PDF(BetaDistribution other) {
            super(other);
        }

        @Override
        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        @Override
        public double evaluate(double input) {
            return PDF.evaluate(input, this.getAlpha(), this.getBeta());
        }

        public static double evaluate(double x, double alpha, double beta) {
            double p = x < 0.0 ? 0.0 : (x > 1.0 ? 0.0 : Math.exp(PDF.logEvaluate(x, alpha, beta)));
            return p;
        }

        @Override
        public double logEvaluate(Double input) {
            return this.logEvaluate((double)input);
        }

        @Override
        public double logEvaluate(double input) {
            return PDF.logEvaluate(input, this.getAlpha(), this.getBeta());
        }

        public static double logEvaluate(double x, double alpha, double beta) {
            double plog;
            if (x < 0.0) {
                plog = Math.log(0.0);
            } else if (x > 1.0) {
                plog = Math.log(0.0);
            } else {
                double n1 = (alpha - 1.0) * Math.log(x);
                double n2 = (beta - 1.0) * Math.log(1.0 - x);
                double d1 = MathUtil.logBetaFunction(alpha, beta);
                plog = n1 + n2 - d1;
            }
            return plog;
        }

        @Override
        public PDF getProbabilityFunction() {
            return this;
        }
    }

    @PublicationReference(author={"Andrew Gelman", "John B. Carlin", "Hal S. Stern", "Donald B. Rubin"}, title="Bayesian Data Analysis, Second Edition", type=PublicationType.Book, year=2004, pages={582}, notes={"Equation A.3"})
    public static class WeightedMomentMatchingEstimator
    extends AbstractCloneableSerializable
    implements DistributionWeightedEstimator<Double, BetaDistribution> {
        @Override
        public BetaDistribution learn(Collection<? extends WeightedValue<? extends Double>> data) {
            Pair<Double, Double> pair = UnivariateStatisticsUtil.computeWeightedMeanAndVariance(data);
            return MomentMatchingEstimator.learn(pair.getFirst(), pair.getSecond());
        }
    }

    @PublicationReference(author={"Andrew Gelman", "John B. Carlin", "Hal S. Stern", "Donald B. Rubin"}, title="Bayesian Data Analysis, Second Edition", type=PublicationType.Book, year=2004, pages={582}, notes={"Equation A.3"})
    public static class MomentMatchingEstimator
    extends AbstractCloneableSerializable
    implements DistributionEstimator<Double, BetaDistribution> {
        @Override
        public BetaDistribution learn(Collection<? extends Double> data) {
            Pair<Double, Double> pair = UnivariateStatisticsUtil.computeMeanAndVariance(data);
            return MomentMatchingEstimator.learn(pair.getFirst(), pair.getSecond());
        }

        public static BetaDistribution learn(double mean, double variance) {
            double apb = mean * (1.0 - mean) / variance - 1.0;
            double alpha = Math.abs(apb * mean);
            double beta = Math.abs(apb * (1.0 - mean));
            return new BetaDistribution(alpha, beta);
        }
    }
}

