/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.AbstractClosedFormSmoothUnivariateDistribution;
import gov.sandia.cognition.statistics.SmoothCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.UnivariateProbabilityDensityFunction;
import gov.sandia.cognition.statistics.distribution.GammaDistribution;
import java.util.ArrayList;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Chi-square distribution", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Chi-square_distribution")
public class ChiSquareDistribution
extends AbstractClosedFormSmoothUnivariateDistribution {
    public static final double DEFAULT_DEGREES_OF_FREEDOM = 2.0;
    private double degreesOfFreedom;

    public ChiSquareDistribution() {
        this(2.0);
    }

    public ChiSquareDistribution(double degreesOfFreedom) {
        this.setDegreesOfFreedom(degreesOfFreedom);
    }

    public ChiSquareDistribution(ChiSquareDistribution other) {
        this(other.getDegreesOfFreedom());
    }

    @Override
    public ChiSquareDistribution clone() {
        return (ChiSquareDistribution)super.clone();
    }

    public double getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    public void setDegreesOfFreedom(double degreesOfFreedom) {
        if (degreesOfFreedom <= 0.0) {
            throw new IllegalArgumentException("Degrees of Freedom must be > 0.0");
        }
        this.degreesOfFreedom = degreesOfFreedom;
    }

    @Override
    public Double getMean() {
        return this.getDegreesOfFreedom();
    }

    @Override
    public double getVariance() {
        return 2.0 * this.getDegreesOfFreedom();
    }

    @Override
    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(this.getDegreesOfFreedom());
    }

    @Override
    public void convertFromVector(Vector parameters) {
        if (parameters.getDimensionality() != 1) {
            throw new IllegalArgumentException("Expected 1-dimensional Vector of parameters!");
        }
        this.setDegreesOfFreedom(parameters.getElement(0));
    }

    @Override
    public ArrayList<Double> sample(Random random, int numSamples) {
        return ChiSquareDistribution.sample(this.degreesOfFreedom, random, numSamples);
    }

    public static ArrayList<Double> sample(double degreesOfFreedom, Random random, int numSamples) {
        return GammaDistribution.sample(degreesOfFreedom / 2.0, 2.0, random, numSamples);
    }

    @Override
    public CDF getCDF() {
        return new CDF(this);
    }

    @Override
    public PDF getProbabilityFunction() {
        return new PDF(this);
    }

    @Override
    public Double getMinSupport() {
        return 0.0;
    }

    @Override
    public Double getMaxSupport() {
        return Double.POSITIVE_INFINITY;
    }

    public static class CDF
    extends ChiSquareDistribution
    implements SmoothCumulativeDistributionFunction {
        public CDF() {
        }

        public CDF(double degreesOfFreedom) {
            super(degreesOfFreedom);
        }

        public CDF(ChiSquareDistribution other) {
            super(other);
        }

        @Override
        public double evaluate(double input) {
            return CDF.evaluate(input, this.getDegreesOfFreedom());
        }

        @Override
        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        public static double evaluate(double input, double degreesOfFreedom) {
            if (degreesOfFreedom <= 0.0) {
                throw new IllegalArgumentException("Degrees of Freedom must be > 0.0");
            }
            return GammaDistribution.CDF.evaluate(input, degreesOfFreedom / 2.0, 2.0);
        }

        @Override
        public CDF getCDF() {
            return this;
        }

        @Override
        public PDF getDerivative() {
            return this.getProbabilityFunction();
        }

        @Override
        public Double differentiate(Double input) {
            return this.getDerivative().evaluate(input);
        }
    }

    public static class PDF
    extends ChiSquareDistribution
    implements UnivariateProbabilityDensityFunction {
        public PDF() {
        }

        public PDF(double degreesOfFreedom) {
            super(degreesOfFreedom);
        }

        public PDF(ChiSquareDistribution other) {
            super(other);
        }

        @Override
        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        @Override
        public double evaluate(double input) {
            return PDF.evaluate(input, this.getDegreesOfFreedom());
        }

        public static double evaluate(double x, double degreesOfFreedom) {
            return Math.exp(PDF.logEvaluate(x, degreesOfFreedom));
        }

        @Override
        public double logEvaluate(Double input) {
            return this.logEvaluate((double)input);
        }

        @Override
        public double logEvaluate(double input) {
            return PDF.logEvaluate(input, this.getDegreesOfFreedom());
        }

        public static double logEvaluate(double x, double degreesOfFreedom) {
            return GammaDistribution.PDF.logEvaluate(x, degreesOfFreedom / 2.0, 2.0);
        }

        @Override
        public PDF getProbabilityFunction() {
            return this;
        }
    }
}

