/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.UnivariateScalarFunction;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.AbstractClosedFormUnivariateDistribution;
import gov.sandia.cognition.statistics.ClosedFormCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.ClosedFormDiscreteUnivariateDistribution;
import gov.sandia.cognition.statistics.ProbabilityMassFunction;
import gov.sandia.cognition.statistics.ProbabilityMassFunctionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Degenerate distribution", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Degenerate_distribution")
public class DeterministicDistribution
extends AbstractClosedFormUnivariateDistribution<Double>
implements ClosedFormDiscreteUnivariateDistribution<Double> {
    public static final double DEFAULT_POINT = 0.0;
    private double point;

    public DeterministicDistribution() {
        this(0.0);
    }

    public DeterministicDistribution(double point) {
        this.setPoint(point);
    }

    public DeterministicDistribution(DeterministicDistribution other) {
        this(other.getPoint());
    }

    public double getPoint() {
        return this.point;
    }

    public void setPoint(double point) {
        this.point = point;
    }

    @Override
    public Double getMean() {
        return this.getPoint();
    }

    @Override
    public ArrayList<Double> sample(Random random, int numSamples) {
        ArrayList<Double> samples = new ArrayList<Double>(numSamples);
        for (int n = 0; n < numSamples; ++n) {
            samples.add(this.getPoint());
        }
        return samples;
    }

    @Override
    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(this.getPoint());
    }

    @Override
    public void convertFromVector(Vector parameters) {
        if (parameters.getDimensionality() != 1) {
            throw new IllegalArgumentException("Parameter dimension must be 1");
        }
        this.setPoint(parameters.getElement(0));
    }

    @Override
    public double getVariance() {
        return 0.0;
    }

    public CDF getCDF() {
        return new CDF(this);
    }

    @Override
    public Double getMinSupport() {
        return this.getPoint();
    }

    @Override
    public Double getMaxSupport() {
        return this.getPoint();
    }

    @Override
    public Collection<Double> getDomain() {
        return Arrays.asList(this.getPoint());
    }

    @Override
    public int getDomainSize() {
        return 1;
    }

    public PMF getProbabilityFunction() {
        return new PMF(this);
    }

    public static class CDF
    extends DeterministicDistribution
    implements ClosedFormCumulativeDistributionFunction<Double>,
    UnivariateScalarFunction {
        public CDF() {
        }

        public CDF(double point) {
            super(point);
        }

        public CDF(DeterministicDistribution other) {
            super(other);
        }

        @Override
        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        @Override
        public double evaluate(double input) {
            return input < this.getPoint() ? 0.0 : 1.0;
        }

        @Override
        public CDF getCDF() {
            return this;
        }
    }

    public static class PMF
    extends DeterministicDistribution
    implements ProbabilityMassFunction<Double> {
        public PMF() {
        }

        public PMF(double point) {
            super(point);
        }

        public PMF(DeterministicDistribution other) {
            super(other);
        }

        @Override
        public double getEntropy() {
            return ProbabilityMassFunctionUtil.getEntropy(this);
        }

        @Override
        public double logEvaluate(Double input) {
            return Math.log(this.evaluate(input));
        }

        @Override
        public Double evaluate(Double input) {
            return input.doubleValue() == this.getPoint() ? 1.0 : 0.0;
        }

        @Override
        public PMF getProbabilityFunction() {
            return this;
        }
    }
}

