/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.MathUtil;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.VectorInputEvaluator;
import gov.sandia.cognition.statistics.AbstractDistribution;
import gov.sandia.cognition.statistics.ClosedFormComputableDistribution;
import gov.sandia.cognition.statistics.ProbabilityDensityFunction;
import gov.sandia.cognition.statistics.distribution.GammaDistribution;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Dirichlet distribution", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Dirichlet_distribution")
public class DirichletDistribution
extends AbstractDistribution<Vector>
implements ClosedFormComputableDistribution<Vector> {
    protected Vector parameters;

    public DirichletDistribution() {
        this(2);
    }

    public DirichletDistribution(int dimensionality) {
        this(VectorFactory.getDefault().createVector(dimensionality, 1.0));
    }

    public DirichletDistribution(Vector parameters) {
        this.setParameters(parameters);
    }

    public DirichletDistribution(DirichletDistribution other) {
        this(ObjectUtil.cloneSafe(other.getParameters()));
    }

    @Override
    public DirichletDistribution clone() {
        DirichletDistribution clone = (DirichletDistribution)super.clone();
        clone.setParameters(ObjectUtil.cloneSafe(this.getParameters()));
        return clone;
    }

    @Override
    public Vector getMean() {
        return (Vector)this.parameters.scale(1.0 / this.parameters.norm1());
    }

    @Override
    public ArrayList<Vector> sample(Random random, int numSamples) {
        GammaDistribution.CDF gammaRV = new GammaDistribution.CDF(1.0, 1.0);
        int K = this.getParameters().getDimensionality();
        ArrayList<ArrayList<Double>> gammaData = new ArrayList<ArrayList<Double>>(K);
        for (int i = 0; i < K; ++i) {
            double ai = this.parameters.getElement(i);
            gammaRV.setShape(ai);
            gammaData.add(gammaRV.sample(random, numSamples));
        }
        ArrayList<Vector> data = new ArrayList<Vector>(numSamples);
        for (int n = 0; n < numSamples; ++n) {
            Vector y = VectorFactory.getDefault().createVector(K);
            double ysum = 0.0;
            for (int i = 0; i < K; ++i) {
                double yin = (Double)((ArrayList)gammaData.get(i)).get(n);
                ysum += yin;
                y.setElement(i, yin);
            }
            if (ysum != 0.0) {
                y.scaleEquals(1.0 / ysum);
            }
            data.add(y);
        }
        return data;
    }

    @Override
    public Vector convertToVector() {
        return ObjectUtil.cloneSafe(this.getParameters());
    }

    @Override
    public void convertFromVector(Vector parameters) {
        parameters.assertSameDimensionality(this.getParameters());
        this.setParameters(ObjectUtil.cloneSafe(parameters));
    }

    public Vector getParameters() {
        return this.parameters;
    }

    public void setParameters(Vector parameters) {
        int N = parameters.getDimensionality();
        if (N < 2) {
            throw new IllegalArgumentException("Dimensionality must be >= 2");
        }
        for (int i = 0; i < N; ++i) {
            if (!(parameters.getElement(i) <= 0.0)) continue;
            throw new IllegalArgumentException("All parameter elements must be > 0.0");
        }
        this.parameters = parameters;
    }

    public PDF getProbabilityFunction() {
        return new PDF(this);
    }

    public static class PDF
    extends DirichletDistribution
    implements ProbabilityDensityFunction<Vector>,
    VectorInputEvaluator<Vector, Double> {
        public PDF() {
        }

        public PDF(Vector parameters) {
            super(parameters);
        }

        public PDF(DirichletDistribution other) {
            super(other);
        }

        @Override
        public Double evaluate(Vector input) {
            Vector xn = (Vector)input.scale(1.0 / input.norm1());
            Vector a = this.getParameters();
            input.assertSameDimensionality(a);
            double logsum = 0.0;
            int K = a.getDimensionality();
            for (int i = 0; i < K; ++i) {
                double xi = xn.getElement(i);
                if (xi <= 0.0 || 1.0 <= xi) {
                    throw new IllegalArgumentException("Expected all inputs to be (0.0,infinity): " + input);
                }
                double ai = a.getElement(i);
                logsum += (ai - 1.0) * Math.log(xi);
            }
            return Math.exp(logsum -= MathUtil.logMultinomialBetaFunction(a));
        }

        @Override
        public double logEvaluate(Vector input) {
            Vector xn = (Vector)input.scale(1.0 / input.norm1());
            Vector a = this.getParameters();
            input.assertSameDimensionality(a);
            double logsum = 0.0;
            int K = a.getDimensionality();
            for (int i = 0; i < K; ++i) {
                double xi = xn.getElement(i);
                if (xi <= 0.0 || 1.0 <= xi) {
                    throw new IllegalArgumentException("Expected all inputs to be (0.0,infinity): " + input);
                }
                double ai = a.getElement(i);
                logsum += (ai - 1.0) * Math.log(xi);
            }
            return logsum -= MathUtil.logMultinomialBetaFunction(a);
        }

        @Override
        public int getInputDimensionality() {
            return this.parameters != null ? this.parameters.getDimensionality() : 0;
        }

        @Override
        public PDF getProbabilityFunction() {
            return this;
        }
    }
}

