/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.UnivariateStatisticsUtil;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.AbstractClosedFormSmoothUnivariateDistribution;
import gov.sandia.cognition.statistics.DistributionEstimator;
import gov.sandia.cognition.statistics.DistributionWeightedEstimator;
import gov.sandia.cognition.statistics.EstimableDistribution;
import gov.sandia.cognition.statistics.InvertibleCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.SmoothCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.UnivariateProbabilityDensityFunction;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.WeightedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Exponential distribution", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Exponential_distribution")
public class ExponentialDistribution
extends AbstractClosedFormSmoothUnivariateDistribution
implements EstimableDistribution<Double, ExponentialDistribution> {
    public static final double DEFAULT_RATE = 1.0;
    protected double rate;

    public ExponentialDistribution() {
        this(1.0);
    }

    public ExponentialDistribution(double rate) {
        this.setRate(rate);
    }

    public ExponentialDistribution(ExponentialDistribution other) {
        this(other.getRate());
    }

    @Override
    public ExponentialDistribution clone() {
        return (ExponentialDistribution)super.clone();
    }

    public double getRate() {
        return this.rate;
    }

    public void setRate(double rate) {
        if (rate <= 0.0) {
            throw new IllegalArgumentException("Rate must be > 0.0");
        }
        this.rate = rate;
    }

    @Override
    public Double getMean() {
        return 1.0 / this.getRate();
    }

    @Override
    @PublicationReference(author={"Christian P. Robert", "George Casella"}, title="Monte Carlo Statistical Methods, Second Edition", type=PublicationType.Book, year=2004, pages={39}, notes={"Example 2.5"})
    public ArrayList<Double> sample(Random random, int numSamples) {
        double negativeInverseScale = -1.0 / this.rate;
        ArrayList<Double> retval = new ArrayList<Double>(numSamples);
        for (int n = 0; n < numSamples; ++n) {
            double u = random.nextDouble();
            retval.add(Math.log(u) * negativeInverseScale);
        }
        return retval;
    }

    @Override
    public CDF getCDF() {
        return new CDF(this);
    }

    @Override
    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(this.getRate());
    }

    @Override
    public void convertFromVector(Vector parameters) {
        parameters.assertDimensionalityEquals(1);
        this.setRate(parameters.getElement(0));
    }

    @Override
    public double getVariance() {
        double d2 = this.rate * this.rate;
        return 1.0 / d2;
    }

    @Override
    public PDF getProbabilityFunction() {
        return new PDF(this);
    }

    @Override
    public Double getMinSupport() {
        return 0.0;
    }

    @Override
    public Double getMaxSupport() {
        return Double.POSITIVE_INFINITY;
    }

    public MaximumLikelihoodEstimator getEstimator() {
        return new MaximumLikelihoodEstimator();
    }

    public String toString() {
        return "Rate: " + this.getRate();
    }

    public static class WeightedMaximumLikelihoodEstimator
    extends AbstractCloneableSerializable
    implements DistributionWeightedEstimator<Double, ExponentialDistribution> {
        @Override
        public ExponentialDistribution learn(Collection<? extends WeightedValue<? extends Double>> data) {
            double mean = UnivariateStatisticsUtil.computeWeightedMean(data);
            return new ExponentialDistribution(1.0 / mean);
        }
    }

    public static class MaximumLikelihoodEstimator
    extends AbstractCloneableSerializable
    implements DistributionEstimator<Double, ExponentialDistribution> {
        @Override
        public ExponentialDistribution learn(Collection<? extends Double> data) {
            double mean = UnivariateStatisticsUtil.computeMean(data);
            return new ExponentialDistribution(1.0 / mean);
        }
    }

    public static class CDF
    extends ExponentialDistribution
    implements SmoothCumulativeDistributionFunction,
    InvertibleCumulativeDistributionFunction<Double> {
        public CDF() {
        }

        public CDF(double rate) {
            super(rate);
        }

        public CDF(ExponentialDistribution other) {
            super(other);
        }

        @Override
        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        @Override
        public double evaluate(double input) {
            if (input <= 0.0) {
                return 0.0;
            }
            return 1.0 - Math.exp(-input * this.rate);
        }

        @Override
        public CDF getCDF() {
            return this;
        }

        @Override
        public PDF getDerivative() {
            return this.getProbabilityFunction();
        }

        @Override
        public Double differentiate(Double input) {
            return this.getDerivative().evaluate(input);
        }

        @Override
        public Double inverse(double probability) {
            if (probability <= 0.0) {
                return this.getMinSupport();
            }
            if (probability >= 1.0) {
                return this.getMaxSupport();
            }
            return -Math.log(1.0 - probability) / this.rate;
        }
    }

    public static class PDF
    extends ExponentialDistribution
    implements UnivariateProbabilityDensityFunction {
        public PDF() {
        }

        public PDF(double rate) {
            super(rate);
        }

        public PDF(ExponentialDistribution other) {
            super(other);
        }

        @Override
        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        @Override
        public double evaluate(double input) {
            if (input < 0.0) {
                return 0.0;
            }
            return this.rate * Math.exp(-input * this.rate);
        }

        @Override
        public double logEvaluate(Double input) {
            return this.logEvaluate((double)input);
        }

        @Override
        public double logEvaluate(double input) {
            if (input < 0.0) {
                return Math.log(0.0);
            }
            double n1 = Math.log(this.rate);
            double n2 = -input * this.rate;
            return n1 + n2;
        }

        @Override
        public PDF getProbabilityFunction() {
            return this;
        }
    }
}

