/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.MathUtil;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.AbstractClosedFormSmoothUnivariateDistribution;
import gov.sandia.cognition.statistics.SmoothCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.UnivariateProbabilityDensityFunction;
import gov.sandia.cognition.statistics.distribution.GammaDistribution;
import java.util.ArrayList;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Inverse-gamma distribution", type=PublicationType.WebPage, year=2010, url="http://en.wikipedia.org/wiki/Inverse-gamma_distribution")
public class InverseGammaDistribution
extends AbstractClosedFormSmoothUnivariateDistribution {
    public static final double DEFAULT_SHAPE = 3.0;
    public static final double DEFAULT_SCALE = 1.0;
    protected double shape;
    protected double scale;

    public InverseGammaDistribution() {
        this(3.0, 1.0);
    }

    public InverseGammaDistribution(double shape, double scale) {
        this.shape = shape;
        this.scale = scale;
    }

    public InverseGammaDistribution(InverseGammaDistribution other) {
        this(other.getShape(), other.getScale());
    }

    @Override
    public InverseGammaDistribution clone() {
        return (InverseGammaDistribution)super.clone();
    }

    public double getShape() {
        return this.shape;
    }

    public void setShape(double shape) {
        if (shape <= 0.0) {
            throw new IllegalArgumentException("Shape must be > 0.0");
        }
        this.shape = shape;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("Scale must be > 0.0");
        }
        this.scale = scale;
    }

    @Override
    public ArrayList<? extends Double> sample(Random random, int numSamples) {
        ArrayList<Double> gammas = GammaDistribution.sample(this.shape, 1.0 / this.scale, random, numSamples);
        ArrayList<Double> samples = new ArrayList<Double>(numSamples);
        for (int n = 0; n < numSamples; ++n) {
            double g = gammas.get(n);
            samples.add(1.0 / g);
        }
        return samples;
    }

    @Override
    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(this.shape, this.scale);
    }

    @Override
    public void convertFromVector(Vector parameters) {
        parameters.assertDimensionalityEquals(2);
        this.setShape(parameters.getElement(0));
        this.setScale(parameters.getElement(1));
    }

    @Override
    public Double getMean() {
        if (this.shape > 1.0) {
            return this.scale / (this.shape - 1.0);
        }
        throw new IllegalArgumentException("Shape must be > 1.0");
    }

    @Override
    public double getVariance() {
        if (this.shape > 2.0) {
            double am1 = this.shape - 1.0;
            double am2 = this.shape - 2.0;
            return this.scale * this.scale / (am1 * am1 * am2);
        }
        throw new IllegalArgumentException("Shape must be > 2.0");
    }

    @Override
    public CDF getCDF() {
        return new CDF(this);
    }

    @Override
    public PDF getProbabilityFunction() {
        return new PDF(this);
    }

    public String toString() {
        return "Shape = " + this.getShape() + ", Scale = " + this.getScale();
    }

    @Override
    public Double getMinSupport() {
        return 0.0;
    }

    @Override
    public Double getMaxSupport() {
        return Double.POSITIVE_INFINITY;
    }

    public static class PDF
    extends InverseGammaDistribution
    implements UnivariateProbabilityDensityFunction {
        public PDF() {
        }

        public PDF(double shape, double scale) {
            super(shape, scale);
        }

        public PDF(InverseGammaDistribution other) {
            super(other);
        }

        @Override
        public PDF getProbabilityFunction() {
            return this;
        }

        @Override
        public double logEvaluate(Double input) {
            return this.logEvaluate((double)input);
        }

        @Override
        public double logEvaluate(double input) {
            if (input > 0.0) {
                double logSum = 0.0;
                logSum += this.shape * Math.log(this.scale);
                logSum -= MathUtil.logGammaFunction(this.shape);
                logSum -= (this.shape + 1.0) * Math.log(input);
                return logSum -= this.scale / input;
            }
            return Math.log(0.0);
        }

        @Override
        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        @Override
        public double evaluate(double input) {
            return Math.exp(this.logEvaluate(input));
        }
    }

    public static class CDF
    extends InverseGammaDistribution
    implements SmoothCumulativeDistributionFunction {
        public CDF() {
        }

        public CDF(double shape, double scale) {
            super(shape, scale);
        }

        public CDF(InverseGammaDistribution other) {
            super(other);
        }

        @Override
        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        @Override
        public double evaluate(double input) {
            if (input > 0.0) {
                return 1.0 - GammaDistribution.CDF.evaluate(1.0 / input, this.shape, 1.0 / this.scale);
            }
            return 0.0;
        }

        @Override
        public CDF getCDF() {
            return this;
        }

        @Override
        public PDF getDerivative() {
            return this.getProbabilityFunction();
        }

        @Override
        public Double differentiate(Double input) {
            return this.getDerivative().evaluate(input);
        }
    }
}

