/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.MathUtil;
import gov.sandia.cognition.math.RingAccumulator;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrixFactoryMTJ;
import gov.sandia.cognition.math.matrix.mtj.decomposition.CholeskyDecompositionMTJ;
import gov.sandia.cognition.statistics.AbstractDistribution;
import gov.sandia.cognition.statistics.ClosedFormComputableDistribution;
import gov.sandia.cognition.statistics.ProbabilityDensityFunction;
import gov.sandia.cognition.statistics.distribution.MultivariateGaussian;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Random;

@PublicationReferences(references={@PublicationReference(author={"Stanley Sawyer"}, title="Wishart Distributions and Inverse-Wishart Sampling", type=PublicationType.Misc, year=2007, url="http://www.math.wustl.edu/~sawyer/hmhandouts/Wishart.pdf"), @PublicationReference(author={"Wikipedia"}, title="Inverse-Wishart distribution", type=PublicationType.WebPage, year=2010, url="http://en.wikipedia.org/wiki/Inverse-Wishart_distribution")})
public class InverseWishartDistribution
extends AbstractDistribution<Matrix>
implements ClosedFormComputableDistribution<Matrix> {
    public static final int DEFAULT_DIMENSIONALITY = 2;
    protected Matrix inverseScale;
    protected int degreesOfFreedom;
    private transient Matrix scaleSqrt;

    public InverseWishartDistribution() {
        this(2);
    }

    public InverseWishartDistribution(int dimensionality) {
        this(MatrixFactory.getDefault().createIdentity(dimensionality, dimensionality), dimensionality + 2);
    }

    public InverseWishartDistribution(Matrix inverseScale, int degreesOfFreedom) {
        this.setInverseScale(inverseScale);
        this.setDegreesOfFreedom(degreesOfFreedom);
    }

    public InverseWishartDistribution(InverseWishartDistribution other) {
        this(ObjectUtil.cloneSafe(other.getInverseScale()), other.getDegreesOfFreedom());
    }

    @Override
    public InverseWishartDistribution clone() {
        InverseWishartDistribution clone = (InverseWishartDistribution)super.clone();
        clone.setInverseScale(ObjectUtil.cloneSafe(this.getInverseScale()));
        return clone;
    }

    public int getInputDimensionality() {
        return this.getInverseScale().getNumRows();
    }

    @Override
    public Matrix getMean() {
        int p = this.getInputDimensionality();
        double denominator = (double)(this.getDegreesOfFreedom() - p) - 1.0;
        return (Matrix)this.getInverseScale().scale(1.0 / denominator);
    }

    public static Matrix sample(Random random, Vector mean, Matrix covarianceSqrt, int degreesOfFreedom) {
        ArrayList<Vector> xs = MultivariateGaussian.sample(mean, covarianceSqrt, random, degreesOfFreedom);
        RingAccumulator<Matrix> sum = new RingAccumulator<Matrix>();
        for (Vector x : xs) {
            sum.accumulate(x.outerProduct(x));
        }
        return ((Matrix)sum.getSum()).inverse();
    }

    @Override
    public ArrayList<Matrix> sample(Random random, int numSamples) {
        Matrix covarianceSqrt = this.getScaleSqrt();
        Vector mean = VectorFactory.getDefault().createVector(this.getInputDimensionality());
        ArrayList<Matrix> samples = new ArrayList<Matrix>(numSamples);
        for (int n = 0; n < numSamples; ++n) {
            Matrix B = InverseWishartDistribution.sample(random, mean, covarianceSqrt, this.degreesOfFreedom);
            samples.add(B);
        }
        return samples;
    }

    @Override
    public Vector convertToVector() {
        Vector dof = VectorFactory.getDefault().copyValues(this.getDegreesOfFreedom());
        Vector matrix = this.getInverseScale().convertToVector();
        return dof.stack(matrix);
    }

    @Override
    public void convertFromVector(Vector parameters) {
        int p = this.getInputDimensionality();
        parameters.assertDimensionalityEquals(1 + p * p);
        int dof = (int)Math.round(parameters.getElement(0));
        Vector matrix = parameters.subVector(1, parameters.getDimensionality() - 1);
        this.setDegreesOfFreedom(dof);
        this.getInverseScale().convertFromVector(matrix);
    }

    public Matrix getInverseScale() {
        return this.inverseScale;
    }

    public void setInverseScale(Matrix inverseScale) {
        this.scaleSqrt = null;
        this.inverseScale = inverseScale;
    }

    public int getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    public void setDegreesOfFreedom(int degreesOfFreedom) {
        if (degreesOfFreedom <= this.getInputDimensionality()) {
            throw new IllegalArgumentException("DOFs must be > dimensionality");
        }
        this.degreesOfFreedom = degreesOfFreedom;
    }

    public PDF getProbabilityFunction() {
        return new PDF(this);
    }

    public Matrix getScaleSqrt() {
        if (this.scaleSqrt == null) {
            this.scaleSqrt = CholeskyDecompositionMTJ.create(DenseMatrixFactoryMTJ.INSTANCE.copyMatrix(this.inverseScale.inverse())).getR();
        }
        return this.scaleSqrt;
    }

    @PublicationReference(author={"Wikipedia"}, title="Multivariate gamma function", type=PublicationType.WebPage, year=2010, url="http://en.wikipedia.org/wiki/Multivariate_gamma_function")
    public static class MultivariateGammaFunction {
        public static final double LOG_PI = Math.log(Math.PI);

        public static double logEvaluate(double x, int p) {
            double logSum = 0.0;
            logSum += (double)(p * (p - 1)) / 4.0 * LOG_PI;
            for (int j = 1; j < p; ++j) {
                double y = x + (double)(1 - j) / 2.0;
                logSum += MathUtil.logGammaFunction(y);
            }
            return logSum;
        }
    }

    public static class PDF
    extends InverseWishartDistribution
    implements ProbabilityDensityFunction<Matrix> {
        public static final double LOG_OF_2 = Math.log(2.0);

        public PDF() {
        }

        public PDF(Matrix inverseScale, int degreesOfFreedom) {
            super(inverseScale, degreesOfFreedom);
        }

        public PDF(InverseWishartDistribution other) {
            super(other);
        }

        @Override
        public Double evaluate(Matrix input) {
            return Math.exp(this.logEvaluate(input));
        }

        @Override
        public double logEvaluate(Matrix input) {
            int m = this.getDegreesOfFreedom();
            int p = this.getInputDimensionality();
            double logSum = 0.0;
            logSum += (double)m / 2.0 * this.inverseScale.logDeterminant().getRealPart();
            logSum -= ((double)(m + p) + 1.0) / 2.0 * input.logDeterminant().getRealPart();
            logSum -= this.inverseScale.times(input.inverse()).trace() / 2.0;
            logSum -= (double)(m * p) / 2.0 * LOG_OF_2;
            return logSum -= MultivariateGammaFunction.logEvaluate((double)m / 2.0, p);
        }

        @Override
        public PDF getProbabilityFunction() {
            return this;
        }
    }
}

