/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.AbstractClosedFormUnivariateDistribution;
import gov.sandia.cognition.statistics.ClosedFormCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.method.InverseTransformSampling;
import java.util.ArrayList;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Kolmogorov-Smirnov test, Kolmogorov distribution", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Kolmogorov_distribution#Kolmogorov_distribution")
public class KolmogorovDistribution
extends AbstractClosedFormUnivariateDistribution<Double> {
    public static final double MEAN = 0.868481392844716;
    public static final double VARIANCE = 0.06759934611527044;

    @Override
    public Double getMean() {
        return 0.868481392844716;
    }

    @Override
    public ArrayList<Double> sample(Random random, int numSamples) {
        return InverseTransformSampling.sample(this.getCDF(), random, numSamples);
    }

    @Override
    public double getVariance() {
        return 0.06759934611527044;
    }

    public CDF getCDF() {
        return new CDF();
    }

    @Override
    public Vector convertToVector() {
        return VectorFactory.getDefault().createVector(0);
    }

    @Override
    public void convertFromVector(Vector parameters) {
        parameters.assertDimensionalityEquals(0);
    }

    @Override
    public Double getMinSupport() {
        return 0.0;
    }

    @Override
    public Double getMaxSupport() {
        return Double.POSITIVE_INFINITY;
    }

    public static class CDF
    extends KolmogorovDistribution
    implements ClosedFormCumulativeDistributionFunction<Double> {
        @Override
        public Double evaluate(Double input) {
            return CDF.evaluate(input);
        }

        @PublicationReference(author={"William H. Press", "Saul A. Teukolsky", "Willim T. Vetterling", "Brian P. Flannery"}, title="Numerical Recipes in C, Second Edition", type=PublicationType.Book, year=1992, pages={626}, notes={"Loosely based on the NRC probks() method.", "Returns complement (1.0-value) of the NRC probks() method."}, url="http://www.nrbook.com/a/bookcpdf.php")
        public static double evaluate(double input) {
            if (input < 0.0) {
                return 0.0;
            }
            double fac = 2.0;
            double sum = 0.0;
            double termbf = 0.0;
            double a2 = -2.0 * input * input;
            double EPS1 = 0.001;
            double EPS2 = 1.0E-8;
            int MAX_ITERATIONS = 100;
            for (int j = 1; j <= 100; ++j) {
                double term = fac * Math.exp(a2 * (double)j * (double)j);
                sum += term;
                if (Math.abs(term) < 0.001 * termbf || Math.abs(term) <= 1.0E-8 * sum) {
                    double cdf = 1.0 - sum;
                    if (cdf < 0.0) {
                        cdf = 0.0;
                    }
                    return cdf;
                }
                fac = -fac;
                termbf = Math.abs(term);
            }
            return 0.0;
        }

        @Override
        public CDF getCDF() {
            return this;
        }
    }
}

