/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.NumberAverager;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.AbstractClosedFormSmoothUnivariateDistribution;
import gov.sandia.cognition.statistics.DistributionEstimator;
import gov.sandia.cognition.statistics.DistributionWeightedEstimator;
import gov.sandia.cognition.statistics.EstimableDistribution;
import gov.sandia.cognition.statistics.InvertibleCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.SmoothCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.UnivariateProbabilityDensityFunction;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.WeightedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Laplace distribution", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Laplace_distribution")
public class LaplaceDistribution
extends AbstractClosedFormSmoothUnivariateDistribution
implements EstimableDistribution<Double, LaplaceDistribution> {
    public static final double DEFAULT_MEAN = 0.0;
    public static final double DEFAULT_SCALE = 1.0;
    protected double mean;
    protected double scale;

    public LaplaceDistribution() {
        this(0.0, 1.0);
    }

    public LaplaceDistribution(double mean, double scale) {
        this.setMean(mean);
        this.setScale(scale);
    }

    public LaplaceDistribution(LaplaceDistribution other) {
        this(other.getMean(), other.getScale());
    }

    @Override
    public LaplaceDistribution clone() {
        return (LaplaceDistribution)super.clone();
    }

    @Override
    public Double getMean() {
        return this.mean;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("scale must be > 0.0");
        }
        this.scale = scale;
    }

    @Override
    public ArrayList<Double> sample(Random random, int numSamples) {
        ArrayList<Double> samples = new ArrayList<Double>(numSamples);
        for (int n = 0; n < numSamples; ++n) {
            double p = random.nextDouble();
            samples.add(CDF.inverse(this, p));
        }
        return samples;
    }

    @Override
    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(this.getMean(), this.getScale());
    }

    @Override
    public void convertFromVector(Vector parameters) {
        parameters.assertDimensionalityEquals(2);
        this.setMean(parameters.getElement(0));
        this.setScale(parameters.getElement(1));
    }

    @Override
    public double getVariance() {
        double b = this.getScale();
        return 2.0 * b * b;
    }

    public String toString() {
        return "Mean: " + this.getMean() + ", Scale: " + this.getScale();
    }

    @Override
    public CDF getCDF() {
        return new CDF(this);
    }

    @Override
    public PDF getProbabilityFunction() {
        return new PDF(this);
    }

    @Override
    public Double getMinSupport() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public Double getMaxSupport() {
        return Double.POSITIVE_INFINITY;
    }

    public MaximumLikelihoodEstimator getEstimator() {
        return new MaximumLikelihoodEstimator();
    }

    public static class WeightedMaximumLikelihoodEstimator
    extends AbstractCloneableSerializable
    implements DistributionWeightedEstimator<Double, LaplaceDistribution> {
        @Override
        public LaplaceDistribution learn(Collection<? extends WeightedValue<? extends Double>> data) {
            double mean = 0.0;
            double weightSum = 0.0;
            for (WeightedValue<? extends Double> weightedValue : data) {
                double weight = weightedValue.getWeight();
                if (weight == 0.0) continue;
                double value = weightedValue.getValue();
                mean += weight * value;
                weightSum += weight;
            }
            if (weightSum != 0.0) {
                mean /= weightSum;
            }
            double shape = 0.0;
            for (WeightedValue<? extends Double> weightedValue : data) {
                double weight = weightedValue.getWeight();
                if (weight == 0.0) continue;
                double value = ((Number)weightedValue.getValue()).doubleValue();
                double delta = value - mean;
                shape += weight * Math.abs(delta);
            }
            if (weightSum != 0.0) {
                shape /= weightSum;
            }
            return new LaplaceDistribution(mean, shape);
        }
    }

    public static class MaximumLikelihoodEstimator
    extends AbstractCloneableSerializable
    implements DistributionEstimator<Double, LaplaceDistribution> {
        @Override
        public LaplaceDistribution learn(Collection<? extends Double> data) {
            double mean = (Double)NumberAverager.INSTANCE.summarize(data);
            double absSum = 0.0;
            for (Double d : data) {
                double delta = d - mean;
                absSum += Math.abs(delta);
            }
            double scale = absSum / (double)data.size();
            return new LaplaceDistribution(mean, scale);
        }
    }

    public static class PDF
    extends LaplaceDistribution
    implements UnivariateProbabilityDensityFunction {
        public PDF() {
        }

        public PDF(double mean, double scale) {
            super(mean, scale);
        }

        public PDF(LaplaceDistribution other) {
            super(other);
        }

        @Override
        public double evaluate(double input) {
            double front = 0.5 / this.scale;
            double exponent = -Math.abs(input - this.mean) / this.scale;
            return front * Math.exp(exponent);
        }

        @Override
        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        @Override
        public double logEvaluate(Double input) {
            return this.logEvaluate((double)input);
        }

        @Override
        public double logEvaluate(double input) {
            double n1 = Math.log(0.5 / this.scale);
            double n2 = -Math.abs(input - this.mean) / this.scale;
            return n1 + n2;
        }

        @Override
        public PDF getProbabilityFunction() {
            return this;
        }
    }

    public static class CDF
    extends LaplaceDistribution
    implements SmoothCumulativeDistributionFunction,
    InvertibleCumulativeDistributionFunction<Double> {
        public CDF() {
        }

        public CDF(double mean, double scale) {
            super(mean, scale);
        }

        public CDF(LaplaceDistribution other) {
            super(other);
        }

        @Override
        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        @Override
        public double evaluate(double input) {
            if (input == Double.NEGATIVE_INFINITY) {
                return 0.0;
            }
            if (input == Double.POSITIVE_INFINITY) {
                return 1.0;
            }
            double delta = input - this.mean;
            return 0.5 * (1.0 + Math.signum(delta) * (1.0 - Math.exp(-Math.abs(delta) / this.scale)));
        }

        @Override
        public Double inverse(double p) {
            return CDF.inverse(this, p);
        }

        public static double inverse(LaplaceDistribution laplace, double p) {
            if (p <= 0.0) {
                return laplace.getMinSupport();
            }
            if (p >= 1.0) {
                return laplace.getMaxSupport();
            }
            double delta = p - 0.5;
            return laplace.mean - laplace.scale * Math.signum(delta) * Math.log(1.0 - 2.0 * Math.abs(delta));
        }

        @Override
        public CDF getCDF() {
            return this;
        }

        @Override
        public PDF getDerivative() {
            return this.getProbabilityFunction();
        }

        @Override
        public Double differentiate(Double input) {
            return this.getDerivative().evaluate(input);
        }
    }
}

