/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.factory.Factory;
import gov.sandia.cognition.learning.algorithm.IncrementalLearner;
import gov.sandia.cognition.math.MathUtil;
import gov.sandia.cognition.statistics.AbstractDataHistogram;
import gov.sandia.cognition.statistics.DataHistogram;
import gov.sandia.cognition.statistics.DistributionEstimator;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ArgumentChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class MapBasedDataHistogram<DataType>
extends AbstractDataHistogram<DataType> {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected int totalCount;
    protected Map<DataType, Entry> countMap;

    public MapBasedDataHistogram() {
        this(16);
    }

    public MapBasedDataHistogram(int initialDomainCapacity) {
        this(new LinkedHashMap(initialDomainCapacity));
    }

    public MapBasedDataHistogram(Collection<DataType> data) {
        this(data != null ? data.size() : 16);
        if (data != null) {
            for (DataType x : data) {
                this.add(x);
            }
        }
    }

    public MapBasedDataHistogram(DataHistogram<DataType> other) {
        this(other.getDomain().size());
        for (Object input : other.getDomain()) {
            this.add(input, other.getCount(input));
        }
    }

    protected MapBasedDataHistogram(Map<DataType, Entry> countMap) {
        this.setCountMap(countMap);
    }

    @Override
    public MapBasedDataHistogram<DataType> clone() {
        MapBasedDataHistogram clone = (MapBasedDataHistogram)super.clone();
        clone.countMap = new LinkedHashMap<DataType, Entry>(this.countMap.size());
        for (Object value : this.getDomain()) {
            int count = this.getCount(value);
            clone.countMap.put(value, new Entry(count));
        }
        return clone;
    }

    @Override
    public void add(DataType value, int number) {
        if (number < 0) {
            throw new IllegalArgumentException("number cannot be negative");
        }
        if (number == 0) {
            return;
        }
        Entry entry = this.countMap.get(value);
        if (entry == null) {
            entry = new Entry(number);
            this.countMap.put(value, entry);
        } else {
            entry.count += number;
        }
        this.totalCount += number;
    }

    @Override
    public void remove(DataType value, int number) {
        if (number < 0) {
            throw new IllegalArgumentException("number cannot be negative");
        }
        if (number == 0) {
            return;
        }
        Entry entry = this.countMap.get(value);
        if (entry != null) {
            int oldCount = entry.count;
            int newCount = oldCount - number;
            if (newCount <= 0) {
                this.countMap.remove(value);
                this.totalCount -= oldCount;
            } else {
                entry.count = newCount;
                this.totalCount -= number;
            }
        }
    }

    @Override
    public Set<DataType> getDomain() {
        return this.countMap.keySet();
    }

    @Override
    public int getDomainSize() {
        return this.countMap.size();
    }

    @Override
    public int getCount(DataType input) {
        Entry entry = this.countMap.get(input);
        if (entry == null) {
            return 0;
        }
        return entry.count;
    }

    @Override
    public int getMaximumCount() {
        int max = 0;
        for (Entry entry : this.countMap.values()) {
            int count = entry.count;
            if (count <= max) continue;
            max = count;
        }
        return max;
    }

    @Override
    public DataType getMaximumValue() {
        DataType value = null;
        int max = 0;
        for (Map.Entry<DataType, Entry> entry : this.countMap.entrySet()) {
            int count = entry.getValue().count;
            if (count <= max) continue;
            value = entry.getKey();
            max = count;
        }
        return value;
    }

    @Override
    public LinkedList<DataType> getMaximumValues() {
        int max = this.getMaximumCount();
        LinkedList<DataType> result = new LinkedList<DataType>();
        for (Map.Entry<DataType, Entry> entry : this.countMap.entrySet()) {
            int count = entry.getValue().count;
            if (count != max) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    @Override
    public int getTotalCount() {
        return this.totalCount;
    }

    protected void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    protected Map<DataType, Entry> getCountMap() {
        return this.countMap;
    }

    protected void setCountMap(Map<DataType, Entry> countMap) {
        this.countMap = countMap;
    }

    public DataType getMean() {
        throw new UnsupportedOperationException("mean not supported");
    }

    public double getMeanCount() {
        int valueCount = this.getDomain().size();
        if (valueCount == 0) {
            return 0.0;
        }
        return (double)this.getTotalCount() / (double)valueCount;
    }

    public String toString() {
        int domainSize = this.getDomain().size();
        StringBuilder result = new StringBuilder(domainSize * 100);
        result.append("Histogram has " + domainSize + " domain objects and " + this.getTotalCount() + " total count:\n");
        for (Object value : this.getDomain()) {
            result.append(value);
            result.append(": ");
            result.append(this.getCount(value));
            result.append(" (");
            result.append(this.getFraction(value));
            result.append(")");
            result.append("\n");
        }
        return result.toString();
    }

    @Override
    public ArrayList<? extends DataType> sample(Random random, int numSamples) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public DataHistogram.PMF<DataType> getProbabilityFunction() {
        return new PMF(this);
    }

    @Override
    public double getEntropy() {
        double entropy = 0.0;
        if (this.totalCount > 0) {
            for (Entry entry : this.countMap.values()) {
                if (entry.count <= 0) continue;
                double p = (double)entry.count / (double)this.totalCount;
                entropy -= p * MathUtil.log2(p);
            }
        }
        return entropy;
    }

    public static class DefaultFactory<DataType>
    extends AbstractCloneableSerializable
    implements Factory<MapBasedDataHistogram<DataType>> {
        protected int initialDomainCapacity;

        public DefaultFactory() {
            this(16);
        }

        public DefaultFactory(int initialDomainCapacity) {
            this.setInitialDomainCapacity(initialDomainCapacity);
        }

        @Override
        public MapBasedDataHistogram<DataType> create() {
            return new MapBasedDataHistogram(this.getInitialDomainCapacity());
        }

        public int getInitialDomainCapacity() {
            return this.initialDomainCapacity;
        }

        public void setInitialDomainCapacity(int initialDomainCapacity) {
            ArgumentChecker.assertIsPositive("initialDomainCapacity", initialDomainCapacity);
            this.initialDomainCapacity = initialDomainCapacity;
        }
    }

    public static class Learner<DataType>
    extends AbstractCloneableSerializable
    implements DistributionEstimator<DataType, PMF<DataType>>,
    IncrementalLearner<DataType, PMF<DataType>> {
        @Override
        public PMF<DataType> learn(Collection<? extends DataType> data) {
            PMF<? extends DataType> result = new PMF<DataType>();
            result.addAll(data);
            return result;
        }

        @Override
        public PMF<DataType> createInitialLearnedObject() {
            return new PMF();
        }

        @Override
        public void update(PMF<DataType> target, DataType data) {
            target.add(data);
        }

        @Override
        public void update(PMF<DataType> target, Iterable<? extends DataType> data) {
            target.addAll(data);
        }
    }

    protected static class Entry
    extends AbstractCloneableSerializable {
        protected int count;

        public Entry() {
            this(0);
        }

        public Entry(int count) {
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }

    public static class PMF<DataType>
    extends MapBasedDataHistogram<DataType>
    implements DataHistogram.PMF<DataType> {
        public PMF() {
        }

        public PMF(int initialDomainCapacity) {
            super(initialDomainCapacity);
        }

        public PMF(Collection<DataType> data) {
            super(data);
        }

        public PMF(DataHistogram<DataType> other) {
            super(other);
        }

        protected PMF(Map<DataType, Entry> countMap) {
            super(countMap);
        }

        @Override
        public double logEvaluate(DataType input) {
            return Math.log(this.getFraction(input));
        }

        @Override
        public Double evaluate(DataType input) {
            return this.getFraction(input);
        }

        @Override
        public PMF<DataType> getProbabilityFunction() {
            return this;
        }
    }
}

