/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.statistics.DataHistogram;
import gov.sandia.cognition.statistics.ProbabilityMassFunctionUtil;
import gov.sandia.cognition.statistics.distribution.MapBasedDataHistogram;
import java.util.Collection;
import java.util.TreeMap;

public class MapBasedSortedDataHistogram<DataType extends Comparable<? super DataType>>
extends MapBasedDataHistogram<DataType> {
    public MapBasedSortedDataHistogram() {
        super(new TreeMap());
    }

    public MapBasedSortedDataHistogram(Collection<DataType> data) {
        this();
        if (data != null) {
            for (Comparable x : data) {
                this.add(x);
            }
        }
    }

    public MapBasedSortedDataHistogram(DataHistogram<DataType> other) {
        this();
        for (Comparable input : other.getDomain()) {
            this.add(input, other.getCount(input));
        }
    }

    @Override
    public MapBasedSortedDataHistogram<DataType> clone() {
        MapBasedSortedDataHistogram clone = (MapBasedSortedDataHistogram)super.clone();
        clone.setCountMap(new TreeMap(clone.getCountMap()));
        return clone;
    }

    @Override
    public PMF<DataType> getProbabilityFunction() {
        return new PMF(this);
    }

    public static class PMF<DataType extends Comparable<? super DataType>>
    extends MapBasedSortedDataHistogram<DataType>
    implements DataHistogram.PMF<DataType> {
        public PMF() {
        }

        public PMF(Collection<DataType> data) {
            super(data);
        }

        public PMF(DataHistogram<DataType> other) {
            super(other);
        }

        @Override
        public double getEntropy() {
            return ProbabilityMassFunctionUtil.getEntropy(this);
        }

        @Override
        public double logEvaluate(DataType input) {
            return Math.log(this.evaluate(input));
        }

        @Override
        public Double evaluate(DataType input) {
            return this.getFraction(input);
        }

        @Override
        public PMF<DataType> getProbabilityFunction() {
            return this;
        }
    }
}

