/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.IntegerCollection;
import gov.sandia.cognition.math.MathUtil;
import gov.sandia.cognition.math.ProbabilityUtil;
import gov.sandia.cognition.math.UnivariateStatisticsUtil;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.AbstractClosedFormUnivariateDistribution;
import gov.sandia.cognition.statistics.ClosedFormCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.ClosedFormDiscreteUnivariateDistribution;
import gov.sandia.cognition.statistics.DistributionEstimator;
import gov.sandia.cognition.statistics.DistributionWeightedEstimator;
import gov.sandia.cognition.statistics.EstimableDistribution;
import gov.sandia.cognition.statistics.ProbabilityMassFunction;
import gov.sandia.cognition.statistics.ProbabilityMassFunctionUtil;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.Pair;
import gov.sandia.cognition.util.WeightedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Negative binomial distribution", type=PublicationType.WebPage, year=2010, url="http://en.wikipedia.org/wiki/Negative_binomial_distribution")
public class NegativeBinomialDistribution
extends AbstractClosedFormUnivariateDistribution<Number>
implements ClosedFormDiscreteUnivariateDistribution<Number>,
EstimableDistribution<Number, NegativeBinomialDistribution> {
    public static final double DEFAULT_P = 0.5;
    public static final double DEFAULT_R = 1.0;
    protected double r;
    protected double p;

    public NegativeBinomialDistribution() {
        this(1.0, 0.5);
    }

    public NegativeBinomialDistribution(double r, double p) {
        this.setR(r);
        this.setP(p);
    }

    public NegativeBinomialDistribution(NegativeBinomialDistribution other) {
        this(other.getR(), other.getP());
    }

    @Override
    public NegativeBinomialDistribution clone() {
        return (NegativeBinomialDistribution)super.clone();
    }

    public double getP() {
        return this.p;
    }

    public void setP(double p) {
        ProbabilityUtil.assertIsProbability(p);
        this.p = p;
    }

    public double getR() {
        return this.r;
    }

    public void setR(double r) {
        if (r <= 0.0) {
            throw new IllegalArgumentException("R must be > 0");
        }
        this.r = r;
    }

    @Override
    public Double getMean() {
        return this.r * this.p / (1.0 - this.p);
    }

    @Override
    public ArrayList<? extends Number> sample(Random random, int numSamples) {
        return ProbabilityMassFunctionUtil.sample(this.getProbabilityFunction(), random, numSamples);
    }

    public CDF getCDF() {
        return new CDF(this);
    }

    @Override
    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(this.r, this.p);
    }

    @Override
    public void convertFromVector(Vector parameters) {
        parameters.assertDimensionalityEquals(2);
        this.setR(parameters.getElement(0));
        this.setP(parameters.getElement(1));
    }

    @Override
    public Integer getMinSupport() {
        return 0;
    }

    @Override
    public Integer getMaxSupport() {
        return Integer.MAX_VALUE;
    }

    @Override
    public double getVariance() {
        double np = 1.0 - this.p;
        return this.r * this.p / (np * np);
    }

    public IntegerCollection getDomain() {
        int max = (int)Math.ceil(10.0 * this.getMean() + 10.0);
        return new IntegerCollection(0, max);
    }

    @Override
    public int getDomainSize() {
        return this.getDomain().size();
    }

    public PMF getProbabilityFunction() {
        return new PMF(this);
    }

    public MaximumLikelihoodEstimator getEstimator() {
        return new MaximumLikelihoodEstimator();
    }

    public String toString() {
        System.out.println("r = " + this.getR() + ", p = " + this.getP());
        return super.toString();
    }

    public static class WeightedMaximumLikelihoodEstimator
    extends AbstractCloneableSerializable
    implements DistributionWeightedEstimator<Number, NegativeBinomialDistribution> {
        @Override
        public NegativeBinomialDistribution learn(Collection<? extends WeightedValue<? extends Number>> data) {
            Pair<Double, Double> pair = UnivariateStatisticsUtil.computeWeightedMeanAndVariance(data);
            double mean = pair.getFirst();
            double variance = pair.getSecond();
            double ratio = mean / variance;
            double r = Math.abs(mean * ratio / (ratio - 1.0));
            double p = mean / (mean + r);
            return new PMF(r, p);
        }
    }

    public static class MaximumLikelihoodEstimator
    extends AbstractCloneableSerializable
    implements DistributionEstimator<Number, NegativeBinomialDistribution> {
        @Override
        public PMF learn(Collection<? extends Number> data) {
            Pair<Double, Double> pair = UnivariateStatisticsUtil.computeMeanAndVariance(data);
            double mean = pair.getFirst();
            double variance = pair.getSecond();
            double ratio = mean / variance;
            double r = Math.abs(mean * ratio / (ratio - 1.0));
            double p = mean / (mean + r);
            return new PMF(r, p);
        }
    }

    public static class CDF
    extends NegativeBinomialDistribution
    implements ClosedFormCumulativeDistributionFunction<Number> {
        public CDF() {
        }

        public CDF(double r, double p) {
            super(r, p);
        }

        public CDF(NegativeBinomialDistribution other) {
            super(other);
        }

        @Override
        public Double evaluate(Number input) {
            int k = input.intValue();
            if (k < 0) {
                return 0.0;
            }
            return MathUtil.regularizedIncompleteBetaFunction(this.r, k + 1, 1.0 - this.p);
        }

        @Override
        public CDF getCDF() {
            return this;
        }
    }

    public static class PMF
    extends NegativeBinomialDistribution
    implements ProbabilityMassFunction<Number> {
        public PMF() {
        }

        public PMF(double r, double p) {
            super(r, p);
        }

        public PMF(NegativeBinomialDistribution other) {
            super(other);
        }

        @Override
        public PMF getProbabilityFunction() {
            return this;
        }

        @Override
        public double getEntropy() {
            return ProbabilityMassFunctionUtil.getEntropy(this);
        }

        @Override
        public double logEvaluate(Number input) {
            int k = input.intValue();
            if (k < 0) {
                return Math.log(0.0);
            }
            double logSum = 0.0;
            logSum += MathUtil.logGammaFunction((double)k + this.r);
            logSum -= MathUtil.logFactorial(k);
            logSum -= MathUtil.logGammaFunction(this.r);
            logSum += this.r * Math.log(1.0 - this.p);
            return logSum += (double)k * Math.log(this.p);
        }

        @Override
        public Double evaluate(Number input) {
            return Math.exp(this.logEvaluate(input));
        }
    }
}

