/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.VectorInputEvaluator;
import gov.sandia.cognition.statistics.AbstractDistribution;
import gov.sandia.cognition.statistics.ClosedFormComputableDistribution;
import gov.sandia.cognition.statistics.ProbabilityDensityFunction;
import gov.sandia.cognition.statistics.distribution.InverseGammaDistribution;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;
import java.util.ArrayList;
import java.util.Random;

@PublicationReferences(references={@PublicationReference(author={"Christopher M. Bishop"}, title="Pattern Recognition and Machine Learning", type=PublicationType.Book, year=2006, pages={101}), @PublicationReference(author={"Wikipedia"}, title="Normal-scaled inverse gamma distribution", type=PublicationType.WebPage, year=2010, url="http://en.wikipedia.org/wiki/Normal-scaled_inverse_gamma_distribution")})
public class NormalInverseGammaDistribution
extends AbstractDistribution<Vector>
implements ClosedFormComputableDistribution<Vector> {
    public static final double DEFAULT_LOCATION = 0.0;
    public static final double DEFAULT_PRECISION = 1.0;
    public static final double DEFAULT_SHAPE = 3.0;
    public static final double DEFAULT_SCALE = 1.0;
    private double location;
    private double precision;
    private double shape;
    private double scale;

    public NormalInverseGammaDistribution() {
        this(0.0, 1.0, 3.0, 1.0);
    }

    public NormalInverseGammaDistribution(double location, double precision, double shape, double scale) {
        this.setLocation(location);
        this.setPrecision(precision);
        this.setShape(shape);
        this.setScale(scale);
    }

    public NormalInverseGammaDistribution(NormalInverseGammaDistribution other) {
        this(other.getLocation(), other.getPrecision(), other.getShape(), other.getScale());
    }

    @Override
    public NormalInverseGammaDistribution clone() {
        return (NormalInverseGammaDistribution)super.clone();
    }

    @Override
    public Vector getMean() {
        if (this.shape > 1.0) {
            return VectorFactory.getDefault().copyValues(this.location, this.scale / (this.shape - 1.0));
        }
        throw new IllegalArgumentException("Shape must be > 1.0 for a mean");
    }

    @Override
    public ArrayList<Vector> sample(Random random, int numSamples) {
        InverseGammaDistribution.CDF inverseGamma = new InverseGammaDistribution.CDF(this.shape, this.scale);
        UnivariateGaussian.CDF gaussian = new UnivariateGaussian.CDF(this.location, 1.0 / this.precision);
        ArrayList<? extends Double> variances = inverseGamma.sample(random, numSamples);
        ArrayList<Vector> samples = new ArrayList<Vector>(numSamples);
        for (Double d : variances) {
            gaussian.setVariance(d / this.precision);
            double mean = (Double)gaussian.sample(random);
            samples.add(VectorFactory.getDefault().copyValues(mean, d));
        }
        return samples;
    }

    @Override
    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(this.getLocation(), this.getPrecision(), this.getShape(), this.getScale());
    }

    @Override
    public void convertFromVector(Vector parameters) {
        parameters.assertDimensionalityEquals(4);
        this.setLocation(parameters.getElement(0));
        this.setPrecision(parameters.getElement(1));
        this.setShape(parameters.getElement(2));
        this.setScale(parameters.getElement(3));
    }

    public PDF getProbabilityFunction() {
        return new PDF(this);
    }

    public double getLocation() {
        return this.location;
    }

    public void setLocation(double location) {
        this.location = location;
    }

    public double getPrecision() {
        return this.precision;
    }

    public void setPrecision(double precision) {
        if (precision <= 0.0) {
            throw new IllegalArgumentException("Precision must be > 0.0");
        }
        this.precision = precision;
    }

    public double getShape() {
        return this.shape;
    }

    public void setShape(double shape) {
        if (shape <= 0.0) {
            throw new IllegalArgumentException("Shape must be > 0.0");
        }
        this.shape = shape;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("Scale must be > 0.0");
        }
        this.scale = scale;
    }

    public String toString() {
        return "Location: " + this.getLocation() + ", Precision: " + this.getPrecision() + ", Shape: " + this.getShape() + ", Scale: " + this.getScale();
    }

    public static class PDF
    extends NormalInverseGammaDistribution
    implements ProbabilityDensityFunction<Vector>,
    VectorInputEvaluator<Vector, Double> {
        public PDF() {
        }

        public PDF(double location, double precision, double shape, double scale) {
            super(location, precision, shape, scale);
        }

        public PDF(NormalInverseGammaDistribution other) {
            super(other);
        }

        @Override
        public PDF getProbabilityFunction() {
            return this;
        }

        @Override
        public double logEvaluate(Vector input) {
            input.assertDimensionalityEquals(2);
            double mean = input.getElement(0);
            double variance = input.getElement(1);
            InverseGammaDistribution.PDF inverseGamma = new InverseGammaDistribution.PDF(this.getShape(), this.getScale());
            UnivariateGaussian.PDF gaussian = new UnivariateGaussian.PDF(this.getLocation(), variance / this.getPrecision());
            double logInverseGamma = inverseGamma.logEvaluate(variance);
            double logGaussian = gaussian.logEvaluate(mean);
            return logGaussian + logInverseGamma;
        }

        @Override
        public Double evaluate(Vector input) {
            return Math.exp(this.logEvaluate(input));
        }

        @Override
        public int getInputDimensionality() {
            return 2;
        }
    }
}

