/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.IntegerCollection;
import gov.sandia.cognition.math.MathUtil;
import gov.sandia.cognition.math.UnivariateStatisticsUtil;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.AbstractClosedFormUnivariateDistribution;
import gov.sandia.cognition.statistics.ClosedFormCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.ClosedFormDiscreteUnivariateDistribution;
import gov.sandia.cognition.statistics.DistributionEstimator;
import gov.sandia.cognition.statistics.EstimableDistribution;
import gov.sandia.cognition.statistics.ProbabilityMassFunction;
import gov.sandia.cognition.statistics.ProbabilityMassFunctionUtil;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Poisson distribution", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Poisson_distribution")
public class PoissonDistribution
extends AbstractClosedFormUnivariateDistribution<Number>
implements ClosedFormDiscreteUnivariateDistribution<Number>,
EstimableDistribution<Number, PoissonDistribution> {
    public static final double DEFAULT_RATE = 1.0;
    protected double rate;

    public PoissonDistribution() {
        this(1.0);
    }

    public PoissonDistribution(double rate) {
        this.setRate(rate);
    }

    public PoissonDistribution(PoissonDistribution other) {
        this(other.getRate());
    }

    @Override
    public PoissonDistribution clone() {
        PoissonDistribution clone = (PoissonDistribution)super.clone();
        return clone;
    }

    @Override
    public Double getMean() {
        return this.getRate();
    }

    @Override
    public ArrayList<Number> sample(Random random, int numSamples) {
        return ProbabilityMassFunctionUtil.sample(this.getProbabilityFunction(), random, numSamples);
    }

    public CDF getCDF() {
        return new CDF(this);
    }

    @Override
    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(this.getRate());
    }

    @Override
    public void convertFromVector(Vector parameters) {
        parameters.assertDimensionalityEquals(1);
        this.setRate(parameters.getElement(0));
    }

    @Override
    public double getVariance() {
        return this.getRate();
    }

    public IntegerCollection getDomain() {
        return new IntegerCollection(0, (int)Math.round(this.getRate() * 10.0) + 5);
    }

    @Override
    public int getDomainSize() {
        return this.getDomain().size();
    }

    public PMF getProbabilityFunction() {
        return new PMF(this);
    }

    public double getRate() {
        return this.rate;
    }

    public void setRate(double rate) {
        if (rate <= 0.0) {
            throw new IllegalArgumentException("Rate must be >0.0");
        }
        this.rate = rate;
    }

    @Override
    public Integer getMinSupport() {
        return 0;
    }

    @Override
    public Integer getMaxSupport() {
        return Integer.MAX_VALUE;
    }

    public MaximumLikelihoodEstimator getEstimator() {
        return new MaximumLikelihoodEstimator();
    }

    public static class MaximumLikelihoodEstimator
    extends AbstractCloneableSerializable
    implements DistributionEstimator<Number, PoissonDistribution> {
        @Override
        public PMF learn(Collection<? extends Number> data) {
            double mean = UnivariateStatisticsUtil.computeMean(data);
            return new PMF(mean);
        }
    }

    public static class CDF
    extends PoissonDistribution
    implements ClosedFormCumulativeDistributionFunction<Number> {
        public CDF() {
        }

        public CDF(double rate) {
            super(rate);
        }

        public CDF(PoissonDistribution other) {
            super(other);
        }

        @Override
        public Double evaluate(Number input) {
            int k = (int)Math.floor(input.doubleValue());
            if (k < 0) {
                return 0.0;
            }
            if (k == 0) {
                return Math.exp(-this.rate);
            }
            return 1.0 - MathUtil.lowerIncompleteGammaFunction(k + 1, this.rate);
        }

        @Override
        public CDF getCDF() {
            return this;
        }
    }

    public static class PMF
    extends PoissonDistribution
    implements ProbabilityMassFunction<Number> {
        public PMF() {
        }

        public PMF(double rate) {
            super(rate);
        }

        public PMF(PoissonDistribution other) {
            super(other);
        }

        @Override
        public double getEntropy() {
            return ProbabilityMassFunctionUtil.getEntropy(this);
        }

        @Override
        public Double evaluate(Number input) {
            int k = input.intValue();
            if (k < 0) {
                return 0.0;
            }
            return Math.exp(this.logEvaluate(input));
        }

        @Override
        public double logEvaluate(Number input) {
            int k = input.intValue();
            if (k < 0) {
                return Math.log(0.0);
            }
            if (k == 0) {
                return -this.rate;
            }
            double lambda = this.rate;
            double logSum = (double)k * Math.log(lambda) - lambda - MathUtil.logFactorial(k);
            return logSum;
        }

        @Override
        public PMF getProbabilityFunction() {
            return this;
        }
    }
}

