/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.collection.NumberComparator;
import gov.sandia.cognition.statistics.CumulativeDistributionFunction;
import gov.sandia.cognition.statistics.ProbabilityMassFunction;
import gov.sandia.cognition.statistics.ProbabilityMassFunctionUtil;
import gov.sandia.cognition.statistics.UnivariateDistribution;
import gov.sandia.cognition.statistics.distribution.MapBasedPointMassDistribution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class ScalarDataDistribution
extends MapBasedPointMassDistribution<Number>
implements UnivariateDistribution<Number> {
    public ScalarDataDistribution() {
    }

    public ScalarDataDistribution(Collection<? extends Number> values) {
        super(values);
    }

    public ScalarDataDistribution(MapBasedPointMassDistribution<Number> other) {
        super(other);
    }

    @Override
    public ScalarDataDistribution clone() {
        ScalarDataDistribution clone = (ScalarDataDistribution)super.clone();
        return clone;
    }

    @Override
    public CumulativeDistributionFunction<Number> getCDF() {
        return new CDF(this);
    }

    public static double getMean(MapBasedPointMassDistribution<Number> distribution) {
        double mean = 0.0;
        for (Number value : distribution.getDomain()) {
            mean += value.doubleValue() * distribution.getMass(value);
        }
        double tm = distribution.getTotalMass();
        if (tm <= 0.0) {
            tm = 1.0;
        }
        return mean /= tm;
    }

    @Override
    public Double getMean() {
        return ScalarDataDistribution.getMean(this);
    }

    public static double getVariance(MapBasedPointMassDistribution<Number> distribution) {
        double mean = distribution.getMean().doubleValue();
        double variance = 0.0;
        for (Number value : distribution.getDomain()) {
            double delta = value.doubleValue() - mean;
            double p = distribution.getMass(value);
            variance += p * delta * delta;
        }
        double tm = distribution.getTotalMass();
        if (tm <= 0.0) {
            tm = 1.0;
        }
        return variance /= tm;
    }

    @Override
    public double getVariance() {
        return ScalarDataDistribution.getVariance(this);
    }

    @Override
    public Double getMinSupport() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public Double getMaxSupport() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public Collection<? extends Number> getDomain() {
        Collection domain = super.getDomain();
        ArrayList sortedDomain = CollectionUtil.asArrayList(domain);
        Collections.sort(sortedDomain, NumberComparator.INSTANCE);
        return sortedDomain;
    }

    public static class PMF
    extends ScalarDataDistribution
    implements ProbabilityMassFunction<Number> {
        public PMF() {
        }

        public PMF(Collection<? extends Number> values) {
            super(values);
        }

        public PMF(MapBasedPointMassDistribution<Number> other) {
            super(other);
        }

        @Override
        public double getEntropy() {
            return ProbabilityMassFunctionUtil.getEntropy(this);
        }

        @Override
        public Double evaluate(Number input) {
            double tm = this.getTotalMass();
            if (tm <= 0.0) {
                tm = 1.0;
            }
            return this.getMass(input) / tm;
        }

        @Override
        public double logEvaluate(Number input) {
            return Math.log(this.evaluate(input));
        }
    }

    public static class CDF
    extends ScalarDataDistribution
    implements CumulativeDistributionFunction<Number> {
        public CDF() {
        }

        public CDF(Collection<? extends Number> values) {
            super(values);
        }

        public CDF(MapBasedPointMassDistribution<Number> other) {
            super(other);
        }

        @Override
        public Double evaluate(Number input) {
            double sum = 0.0;
            for (Number number : this.getDomain()) {
                if (NumberComparator.INSTANCE.compare(input, number) < 0) continue;
                double p = this.getMass(number);
                sum += p;
            }
            double tm = this.getTotalMass();
            if (tm <= 0.0) {
                tm = 1.0;
            }
            return sum / tm;
        }

        @Override
        public CumulativeDistributionFunction<Number> getCDF() {
            return this;
        }
    }
}

