/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.UnivariateScalarFunction;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.AbstractClosedFormUnivariateDistribution;
import gov.sandia.cognition.statistics.ClosedFormCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.distribution.BetaDistribution;
import gov.sandia.cognition.statistics.distribution.GammaDistribution;
import java.util.ArrayList;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="F-distribution", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/F-distribution")
public class SnedecorFDistribution
extends AbstractClosedFormUnivariateDistribution<Double> {
    public static final double DEFAULT_V1 = 3.0;
    public static final double DEFAULT_V2 = 5.0;
    private double v1;
    private double v2;

    public SnedecorFDistribution() {
        this(3.0, 5.0);
    }

    public SnedecorFDistribution(double v1, double v2) {
        this.setV1(v1);
        this.setV2(v2);
    }

    public SnedecorFDistribution(SnedecorFDistribution other) {
        this(other.getV1(), other.getV2());
    }

    @Override
    public SnedecorFDistribution clone() {
        return (SnedecorFDistribution)super.clone();
    }

    public double getV1() {
        return this.v1;
    }

    public void setV1(double v1) {
        if (v1 <= 0.0) {
            throw new IllegalArgumentException("v1 must be > 0.0");
        }
        this.v1 = v1;
    }

    public double getV2() {
        return this.v2;
    }

    public void setV2(double v2) {
        if (v2 <= 0.0) {
            throw new IllegalArgumentException("v2 must be > 0.0");
        }
        this.v2 = v2;
    }

    @Override
    public Double getMean() {
        if (this.v2 > 2.0) {
            return this.v2 / (this.v2 - 2.0);
        }
        return this.v2;
    }

    @Override
    public double getVariance() {
        if (this.v2 > 4.0) {
            double t1 = 2.0 * this.v2 * this.v2;
            double t2 = this.v1 + this.v2 - 2.0;
            double top = t1 * t2;
            double b1 = this.v2 - 2.0;
            double b2 = this.v2 - 4.0;
            double bottom = this.v1 * b1 * b1 * b2;
            return top / bottom;
        }
        return 1.0;
    }

    @Override
    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(this.getV1(), this.getV2());
    }

    @Override
    public void convertFromVector(Vector parameters) {
        if (parameters.getDimensionality() != 2) {
            throw new IllegalArgumentException("Parameters must have dimensionality 2");
        }
        this.setV1(parameters.getElement(0));
        this.setV2(parameters.getElement(1));
    }

    @Override
    public ArrayList<Double> sample(Random random, int numSamples) {
        ArrayList<Double> g1 = GammaDistribution.sample(this.v1 / 2.0, 2.0 / this.v1, random, numSamples);
        ArrayList<Double> g2 = GammaDistribution.sample(this.v2 / 2.0, 2.0 / this.v2, random, numSamples);
        ArrayList<Double> samples = new ArrayList<Double>(numSamples);
        for (int n = 0; n < numSamples; ++n) {
            samples.add(g1.get(n) / g2.get(n));
        }
        return samples;
    }

    public CDF getCDF() {
        return new CDF(this);
    }

    @Override
    public Double getMinSupport() {
        return 0.0;
    }

    @Override
    public Double getMaxSupport() {
        return Double.POSITIVE_INFINITY;
    }

    public static class CDF
    extends SnedecorFDistribution
    implements ClosedFormCumulativeDistributionFunction<Double>,
    UnivariateScalarFunction {
        public CDF() {
        }

        public CDF(double v1, double v2) {
            super(v1, v2);
        }

        public CDF(SnedecorFDistribution other) {
            super(other);
        }

        @Override
        public double evaluate(double input) {
            return CDF.evaluate(input, this.getV1(), this.getV2());
        }

        @Override
        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        public static double evaluate(double input, double v1, double v2) {
            double p;
            if (input < 0.0) {
                p = 0.0;
            } else {
                double a = BetaDistribution.CDF.evaluate(v2 / (v2 + v1 * input), 0.5 * v2, 0.5 * v1);
                p = 1.0 - a;
            }
            return p;
        }

        @Override
        public CDF getCDF() {
            return this;
        }
    }
}

