/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.algorithm.ParallelUtil;
import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.UnivariateStatisticsUtil;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.AbstractClosedFormSmoothUnivariateDistribution;
import gov.sandia.cognition.statistics.AbstractClosedFormUnivariateDistribution;
import gov.sandia.cognition.statistics.ClosedFormCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.InvertibleCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.SmoothUnivariateDistribution;
import gov.sandia.cognition.statistics.distribution.StudentTDistribution;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;
import gov.sandia.cognition.util.ArgumentChecker;
import gov.sandia.cognition.util.ObjectUtil;
import gov.sandia.cognition.util.Pair;
import gov.sandia.cognition.util.Randomized;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Callable;

@PublicationReferences(references={@PublicationReference(author={"David M. Lane"}, title="Studentized Range Distribution", type=PublicationType.WebPage, year=2011, url="http://davidmlane.com/hyperstat/A47912.html"), @PublicationReference(author={"Wikipedia"}, title="Studentized range", type=PublicationType.WebPage, year=2011, url="http://en.wikipedia.org/wiki/Studentized_range")})
public class StudentizedRangeDistribution
extends AbstractClosedFormUnivariateDistribution<Double>
implements Randomized {
    public static final int DEFAULT_TREATMENT_COUNT = 2;
    public static final double DEFAULT_DEGREES_OF_FREEDOM = Double.POSITIVE_INFINITY;
    public static final int DEFAULT_NUM_SAMPLES = 1000;
    protected int treatmentCount;
    protected double degreesOfFreedom;
    protected Random random;

    public StudentizedRangeDistribution() {
        this(2, Double.POSITIVE_INFINITY);
    }

    public StudentizedRangeDistribution(int treatmentCount, double degreesOfFreedom) {
        this.setTreatmentCount(treatmentCount);
        this.setDegreesOfFreedom(degreesOfFreedom);
        this.setRandom(new Random(2L));
    }

    public StudentizedRangeDistribution(StudentizedRangeDistribution other) {
        this(other.getTreatmentCount(), other.getDegreesOfFreedom());
    }

    @Override
    public StudentizedRangeDistribution clone() {
        StudentizedRangeDistribution clone = (StudentizedRangeDistribution)super.clone();
        clone.setRandom(ObjectUtil.cloneSmart(this.getRandom()));
        return clone;
    }

    @Override
    public ArrayList<Double> sample(Random random, int numSamples) {
        ArrayList<SampleRange> tasks = new ArrayList<SampleRange>(numSamples);
        AbstractClosedFormSmoothUnivariateDistribution t = this.getDegreesOfFreedom() < 30.0 ? new StudentTDistribution(this.getDegreesOfFreedom()) : new UnivariateGaussian();
        for (int n = 0; n < numSamples; ++n) {
            tasks.add(new SampleRange(random, this.getTreatmentCount(), t));
        }
        try {
            return ParallelUtil.executeInSequence(tasks);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public CDF getCDF() {
        return new CDF(this);
    }

    @Override
    public Double getMean() {
        return UnivariateStatisticsUtil.computeMean(this.sample(this.getRandom(), 1000));
    }

    @Override
    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(this.getTreatmentCount(), this.getDegreesOfFreedom());
    }

    @Override
    public void convertFromVector(Vector parameters) {
        parameters.assertDimensionalityEquals(2);
        this.setTreatmentCount((int)parameters.getElement(0));
        this.setDegreesOfFreedom(parameters.getElement(1));
    }

    @Override
    public Double getMinSupport() {
        return 0.0;
    }

    @Override
    public Double getMaxSupport() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getVariance() {
        return UnivariateStatisticsUtil.computeVariance(this.sample(this.getRandom(), 10000));
    }

    public int getTreatmentCount() {
        return this.treatmentCount;
    }

    public void setTreatmentCount(int treatmentCount) {
        ArgumentChecker.assertIsInRangeInclusive("treatmentCount", treatmentCount, 2.0, Double.POSITIVE_INFINITY);
        this.treatmentCount = treatmentCount;
    }

    public double getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    public void setDegreesOfFreedom(double degreesOfFreedom) {
        ArgumentChecker.assertIsPositive("degreesOfFreedom", degreesOfFreedom);
        this.degreesOfFreedom = degreesOfFreedom;
    }

    @Override
    public Random getRandom() {
        return this.random;
    }

    @Override
    public void setRandom(Random random) {
        this.random = random;
    }

    public static class APStat {
        public static double alnorm(double x, boolean upper) {
            if (x < 0.0) {
                x = -x;
                upper = !upper;
            }
            double y = 0.5 * x * x;
            double alnorm = x > 7.0 && (!upper || !(x <= 18.66)) ? 0.0 : (x <= 1.28 ? 0.5 - x * (0.398942280444 - 0.39990348504 * y / (y + 5.75885480458 - 29.8213557807 / (y + 2.62433121679 + 48.6959930692 / (y + 5.92885724438)))) : 0.398942280385 * Math.exp(-y) / (x - 3.8052E-8 + 1.00000615302 / (x + 3.98064794E-4 + 1.98615381364 / (x - 0.151679116635 + 5.29330324926 / (x + 4.8385912808 - 15.1508972451 / (x + 0.742380924027 + 30.789933034 / (x + 3.99019417011)))))));
            return upper ? alnorm : 1.0 - alnorm;
        }

        public static double ppnd(double p) {
            double q = p - 0.5;
            if (Math.abs(q) > 0.42) {
                double r = Math.min(p, 1.0 - p);
                if (r <= 0.0) {
                    throw new IllegalArgumentException("Invalid p value: " + p);
                }
                r = Math.sqrt(-Math.log(r));
                return (double)(q < 0.0 ? -1 : 1) * (((2.32121276858 * r + 4.85014127135) * r - 2.29796479134) * r - 2.78718931138) / ((1.63706781897 * r + 3.54388924762) * r + 1.0);
            }
            double r = q * q;
            return q * (((-25.44106049637 * r + 41.39119773534) * r - 18.61500062529) * r + 2.50662823884) / ((((3.13082909833 * r - 21.06224101826) * r + 23.08336743743) * r - 8.4735109309) * r + 1.0);
        }

        public static double prtrng(double q, double v, double r) {
            double pcutj = 3.0E-5;
            double pcutk = 1.0E-4;
            double step = 0.45;
            double vmax = 120.0;
            int jmin = 3;
            int jmax = 15;
            int kmin = 7;
            int kmax = 15;
            double prtrng = 0.0;
            if (v < 1.0) {
                throw new IllegalArgumentException("Degrees of freedom must be >= 1.");
            }
            if (r < 2.0) {
                throw new IllegalArgumentException("Number of samples must be >= 2.");
            }
            if (q <= 0.0) {
                return prtrng;
            }
            double g = 0.45 * Math.pow(r, -0.2);
            double gmid = 0.5 * Math.log(r);
            double r1 = r - 1.0;
            double c = Math.log(r * g * 0.39894228);
            double h = 0.0;
            double v2 = 0.0;
            if (v <= 120.0) {
                h = 0.45 * Math.pow(v, -0.5);
                v2 = v * 0.5;
                c = v == 1.0 ? 0.193064705 : (v == 2.0 ? 0.293525326 : Math.sqrt(v2) * 0.318309886 / (1.0 + ((-0.00268132716 / v2 + 0.00347222222) / v2 + 0.0833333333) / v2));
                c = Math.log(c * r * g * h);
            }
            double gstep = g;
            double[] qw = new double[30];
            double[] vw = new double[30];
            qw[0] = -1.0;
            qw[15] = -1.0;
            double pk1 = 1.0;
            double pk2 = 1.0;
            for (int k = 1; k <= 15; ++k) {
                gstep -= g;
                do {
                    gstep = -gstep;
                    double gk = gmid + gstep;
                    double pk = 0.0;
                    if (pk2 > 1.0E-4 || k <= 7) {
                        double w0 = c - gk * gk * 0.5;
                        double pz = APStat.alnorm(gk, true);
                        double x = APStat.alnorm(gk - q, true) - pz;
                        if (x > 0.0) {
                            pk = Math.exp(w0 + r1 * Math.log(x));
                        }
                        if (v <= 120.0) {
                            int jump = -15;
                            block2: do {
                                jump += 15;
                                for (int j = 1; j <= 15; ++j) {
                                    int jj = j + jump;
                                    if (qw[jj - 1] <= 0.0) {
                                        double hj = h * (double)j;
                                        if (j < 15) {
                                            qw[jj] = -1.0;
                                        }
                                        double ehj = Math.exp(hj);
                                        qw[jj - 1] = q * ehj;
                                        vw[jj - 1] = v * (hj + 0.5 - ehj * ehj * 0.5);
                                    }
                                    double pj = 0.0;
                                    x = APStat.alnorm(gk - qw[jj - 1], true) - pz;
                                    if (x > 0.0) {
                                        pj = Math.exp(w0 + vw[jj - 1] + r1 * Math.log(x));
                                    }
                                    pk += pj;
                                    if (!(pj > 3.0E-5 || jj <= 3 && k <= 7)) continue block2;
                                }
                            } while ((h = -h) < 0.0);
                        }
                    }
                    prtrng += pk;
                    if (k > 7 && pk <= 1.0E-4 && pk1 <= 1.0E-4) {
                        return prtrng;
                    }
                    pk2 = pk1;
                    pk1 = pk;
                } while (gstep > 0.0);
            }
            return prtrng;
        }

        public static double qtrng(double p, double v, double r) {
            int jmax = 8;
            double pcut = 0.001;
            double eps = 1.0E-4;
            if (v < 1.0) {
                throw new IllegalArgumentException("Degrees of freedom must be >= 1.");
            }
            if (r < 2.0) {
                throw new IllegalArgumentException("Number of samples must be >= 2.");
            }
            if (p < 0.9 || p > 0.99) {
                throw new IllegalArgumentException("P-value must be in range [0.9,0.99].");
            }
            double q1 = APStat.qtrng0(p, v, r);
            double p1 = APStat.prtrng(q1, v, r);
            double q2 = 0.0;
            double p2 = 0.0;
            double qtrng = q1;
            if (Math.abs(p1 - p) < 0.001) {
                return qtrng;
            }
            if (p1 > p) {
                p1 = 1.75 * p - 0.75 * p1;
            }
            if (p1 < p) {
                p2 = p + (p - p1) * (1.0 - p) / (1.0 - p1) * 0.75;
            }
            if (p2 < 0.8) {
                p2 = 0.8;
            }
            if (p2 > 0.995) {
                p2 = 0.995;
            }
            q2 = APStat.qtrng0(p2, v, r);
            double e1 = 0.0;
            double e2 = 0.0;
            double d = 0.0;
            for (int j = 2; j <= 8; ++j) {
                p2 = APStat.prtrng(q2, v, r);
                e1 = p1 - p;
                e2 = p2 - p;
                qtrng = (q1 + q2) / 2.0;
                d = e2 - e1;
                if (Math.abs(d) > 1.0E-4) {
                    qtrng = (e2 * q1 - e1 * q2) / d;
                }
                if (Math.abs(e1) >= Math.abs(e2)) {
                    q1 = q2;
                    p1 = p2;
                }
                if (Math.abs(p1 - p) < 0.005) {
                    return qtrng;
                }
                q2 = qtrng;
            }
            return qtrng;
        }

        public static double qtrng0(double p, double v, double r) {
            double vmax = 120.0;
            double t = APStat.ppnd(0.5 + 0.5 * p);
            if (v < 120.0) {
                t += (t * t * t + t) / v / 4.0;
            }
            double q = 0.8843 - 0.2368 * t;
            if (v < 120.0) {
                q += -1.214 / v + 1.208 * t / v;
            }
            return t * (q * Math.log(r - 1.0) + 1.4142);
        }
    }

    public static class CDF
    extends StudentizedRangeDistribution
    implements ClosedFormCumulativeDistributionFunction<Double>,
    InvertibleCumulativeDistributionFunction<Double> {
        public CDF() {
        }

        public CDF(int treatmentCount, double degreesOfFreedom) {
            super(treatmentCount, degreesOfFreedom);
        }

        public CDF(StudentizedRangeDistribution other) {
            super(other);
        }

        @Override
        public Double evaluate(Double input) {
            return APStat.prtrng(input, this.getDegreesOfFreedom(), this.getTreatmentCount());
        }

        @Override
        public Double inverse(double probability) {
            return APStat.qtrng(probability, this.getDegreesOfFreedom(), this.getTreatmentCount());
        }

        @Override
        public CDF getCDF() {
            return this;
        }
    }

    protected static class SampleRange
    implements Callable<Double> {
        int treatmentCount;
        Random random;
        SmoothUnivariateDistribution t;

        public SampleRange(Random random, int treatmentCount, SmoothUnivariateDistribution t) {
            this.random = random;
            this.treatmentCount = treatmentCount;
            this.t = t;
        }

        @Override
        public Double call() throws Exception {
            ArrayList means = this.t.sample(this.random, this.treatmentCount);
            Pair<Double, Double> result = UnivariateStatisticsUtil.computeMinAndMax(means);
            double delta = result.getSecond() - result.getFirst();
            means = null;
            return delta;
        }
    }
}

