/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.UnivariateStatisticsUtil;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.AbstractClosedFormSmoothUnivariateDistribution;
import gov.sandia.cognition.statistics.DistributionEstimator;
import gov.sandia.cognition.statistics.EstimableDistribution;
import gov.sandia.cognition.statistics.InvertibleCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.SmoothCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.UnivariateProbabilityDensityFunction;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Uniform distribution (continuous)", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Uniform_distribution_(continuous)")
public class UniformDistribution
extends AbstractClosedFormSmoothUnivariateDistribution
implements EstimableDistribution<Double, UniformDistribution> {
    public static final double DEFAULT_MIN = 0.0;
    public static final double DEFAULT_MAX = 1.0;
    private double minSupport;
    private double maxSupport;

    public UniformDistribution() {
        this(0.0, 1.0);
    }

    public UniformDistribution(double minSupport, double maxSupport) {
        this.setMinSupport(minSupport);
        this.setMaxSupport(maxSupport);
    }

    public UniformDistribution(UniformDistribution other) {
        this(other.getMinSupport(), other.getMaxSupport());
    }

    @Override
    public UniformDistribution clone() {
        return (UniformDistribution)super.clone();
    }

    @Override
    public Double getMean() {
        return (this.getMaxSupport() + this.getMinSupport()) / 2.0;
    }

    @Override
    public double getVariance() {
        double d = this.getMaxSupport() - this.getMinSupport();
        return d * d / 12.0;
    }

    @Override
    public ArrayList<Double> sample(Random random, int numSamples) {
        ArrayList<Double> samples = new ArrayList<Double>(numSamples);
        double a = this.getMinSupport();
        double delta = this.getMaxSupport() - a;
        for (int n = 0; n < numSamples; ++n) {
            double x = random.nextDouble();
            samples.add(x * delta + a);
        }
        return samples;
    }

    @Override
    public Double getMinSupport() {
        return this.minSupport;
    }

    public void setMinSupport(double minSupport) {
        this.minSupport = minSupport;
    }

    @Override
    public Double getMaxSupport() {
        return this.maxSupport;
    }

    public void setMaxSupport(double maxSupport) {
        this.maxSupport = maxSupport;
    }

    @Override
    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(this.getMinSupport(), this.getMaxSupport());
    }

    @Override
    public void convertFromVector(Vector parameters) {
        parameters.assertDimensionalityEquals(2);
        double a = parameters.getElement(0);
        double b = parameters.getElement(1);
        this.setMinSupport(Math.min(a, b));
        this.setMaxSupport(Math.max(a, b));
    }

    @Override
    public CDF getCDF() {
        return new CDF(this);
    }

    @Override
    public PDF getProbabilityFunction() {
        return new PDF(this);
    }

    public MaximumLikelihoodEstimator getEstimator() {
        return new MaximumLikelihoodEstimator();
    }

    @PublicationReference(author={"Wikipedia"}, title="German tank problem", type=PublicationType.WebPage, year=2010, url="http://en.wikipedia.org/wiki/German_tank_problem")
    public static class MaximumLikelihoodEstimator
    extends AbstractCloneableSerializable
    implements DistributionEstimator<Double, UniformDistribution> {
        @Override
        public PDF learn(Collection<? extends Double> data) {
            Pair<Double, Double> result = UnivariateStatisticsUtil.computeMinAndMax(data);
            double min = result.getFirst();
            double max = result.getSecond();
            int k = data.size();
            double a = min - Math.abs(min / (double)k);
            double b = max + Math.abs(max / (double)k);
            return new PDF(a, b);
        }
    }

    public static class PDF
    extends UniformDistribution
    implements UnivariateProbabilityDensityFunction {
        public PDF() {
        }

        public PDF(double minSupport, double maxSupport) {
            super(minSupport, maxSupport);
        }

        public PDF(UniformDistribution other) {
            super(other);
        }

        @Override
        public double evaluate(double input) {
            return PDF.evaluate(input, (Double)this.getMinSupport(), (Double)this.getMaxSupport());
        }

        public static double evaluate(double input, double minSupport, double maxSupport) {
            if (input < minSupport || input > maxSupport) {
                return 0.0;
            }
            double d = maxSupport - minSupport;
            if (d != 0.0) {
                return 1.0 / d;
            }
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        @Override
        public double logEvaluate(Double input) {
            return this.logEvaluate((double)input);
        }

        @Override
        public double logEvaluate(double input) {
            return Math.log(this.evaluate(input));
        }

        @Override
        public PDF getProbabilityFunction() {
            return this;
        }
    }

    public static class CDF
    extends UniformDistribution
    implements SmoothCumulativeDistributionFunction,
    InvertibleCumulativeDistributionFunction<Double> {
        public CDF() {
        }

        public CDF(double minSupport, double maxSupport) {
            super(minSupport, maxSupport);
        }

        public CDF(UniformDistribution other) {
            super(other);
        }

        @Override
        public CDF clone() {
            return (CDF)super.clone();
        }

        @Override
        public double evaluate(double input) {
            return CDF.evaluate(input, (Double)this.getMinSupport(), (Double)this.getMaxSupport());
        }

        @Override
        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        public static double evaluate(double input, double minSupport, double maxSupport) {
            double p = input < minSupport ? 0.0 : (input > maxSupport ? 1.0 : (input - minSupport) / (maxSupport - minSupport));
            return p;
        }

        @Override
        public CDF getCDF() {
            return this;
        }

        @Override
        public PDF getDerivative() {
            return this.getProbabilityFunction();
        }

        @Override
        public Double differentiate(Double input) {
            return this.getDerivative().evaluate(input);
        }

        @Override
        public Double inverse(double probability) {
            if (probability <= 0.0) {
                return this.getMinSupport();
            }
            if (probability >= 1.0) {
                return this.getMaxSupport();
            }
            return probability * ((Double)this.getMaxSupport() - (Double)this.getMinSupport()) + (Double)this.getMinSupport();
        }
    }
}

