/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.IntegerCollection;
import gov.sandia.cognition.math.MathUtil;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.AbstractClosedFormUnivariateDistribution;
import gov.sandia.cognition.statistics.ClosedFormCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.ClosedFormDiscreteUnivariateDistribution;
import gov.sandia.cognition.statistics.ProbabilityMassFunction;
import gov.sandia.cognition.statistics.ProbabilityMassFunctionUtil;
import java.util.ArrayList;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Yule-Simon Distribution", type=PublicationType.WebPage, year=2010, url="http://en.wikipedia.org/wiki/Yule%E2%80%93Simon_distribution")
public class YuleSimonDistribution
extends AbstractClosedFormUnivariateDistribution<Number>
implements ClosedFormDiscreteUnivariateDistribution<Number> {
    public static final double DEFAULT_SHAPE = 3.0;
    protected double shape;

    public YuleSimonDistribution() {
        this(3.0);
    }

    public YuleSimonDistribution(double shape) {
        this.setShape(shape);
    }

    public YuleSimonDistribution(YuleSimonDistribution other) {
        this(other.getShape());
    }

    @Override
    public YuleSimonDistribution clone() {
        return (YuleSimonDistribution)super.clone();
    }

    public double getShape() {
        return this.shape;
    }

    public void setShape(double shape) {
        if (shape <= 0.0) {
            throw new IllegalArgumentException("Shape must be > 0.0");
        }
        this.shape = shape;
    }

    @Override
    public Double getMean() {
        return this.shape / (this.shape - 1.0);
    }

    @Override
    public double getVariance() {
        if (this.shape > 2.0) {
            double mean = this.getMean();
            return mean * mean / (this.shape - 2.0);
        }
        return 0.0;
    }

    @Override
    public ArrayList<Integer> sample(Random random, int numSamples) {
        ArrayList<Integer> samples = new ArrayList<Integer>(numSamples);
        double negativeInverseScale = -1.0 / this.shape;
        for (int n = 0; n < numSamples; ++n) {
            double u = random.nextDouble();
            double e = Math.log(u) * negativeInverseScale;
            double geo = Math.exp(-e);
            double denom = Math.log(1.0 - geo);
            double lnu = Math.log(random.nextDouble());
            samples.add((int)Math.floor(lnu / denom) + 1);
        }
        return samples;
    }

    @Override
    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(this.getShape());
    }

    @Override
    public void convertFromVector(Vector parameters) {
        parameters.assertDimensionalityEquals(1);
        this.setShape(parameters.getElement(0));
    }

    @Override
    public Integer getMinSupport() {
        return 1;
    }

    @Override
    public Number getMaxSupport() {
        return Integer.MAX_VALUE;
    }

    public IntegerCollection getDomain() {
        double std = Math.sqrt(this.getVariance());
        int max = (int)Math.ceil(10.0 * std + 100.0);
        return new IntegerCollection(this.getMinSupport(), max);
    }

    @Override
    public int getDomainSize() {
        return this.getDomain().size();
    }

    public PMF getProbabilityFunction() {
        return new PMF(this);
    }

    public CDF getCDF() {
        return new CDF(this);
    }

    public static class CDF
    extends YuleSimonDistribution
    implements ClosedFormCumulativeDistributionFunction<Number> {
        public CDF() {
        }

        public CDF(double shape) {
            super(shape);
        }

        public CDF(YuleSimonDistribution other) {
            super(other);
        }

        @Override
        public Double evaluate(Number input) {
            int k = input.intValue();
            if (k < 1) {
                return 0.0;
            }
            double bc = Math.exp(MathUtil.logBetaFunction(k, this.shape + 1.0));
            return 1.0 - (double)k * bc;
        }

        @Override
        public CDF getCDF() {
            return this;
        }
    }

    public static class PMF
    extends YuleSimonDistribution
    implements ProbabilityMassFunction<Number> {
        public PMF() {
        }

        public PMF(double shape) {
            super(shape);
        }

        public PMF(YuleSimonDistribution other) {
            super(other);
        }

        @Override
        public double getEntropy() {
            return ProbabilityMassFunctionUtil.getEntropy(this);
        }

        @Override
        public double logEvaluate(Number input) {
            int k = input.intValue();
            if (k < 1) {
                return Math.log(0.0);
            }
            double logSum = 0.0;
            logSum += Math.log(this.shape);
            return logSum += MathUtil.logBetaFunction(k, this.shape + 1.0);
        }

        @Override
        public Double evaluate(Number input) {
            return Math.exp(this.logEvaluate(input));
        }

        @Override
        public PMF getProbabilityFunction() {
            return this;
        }
    }
}

