/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.UnivariateStatisticsUtil;
import gov.sandia.cognition.statistics.distribution.SnedecorFDistribution;
import gov.sandia.cognition.statistics.method.AbstractConfidenceStatistic;
import gov.sandia.cognition.statistics.method.BlockExperimentComparison;
import gov.sandia.cognition.statistics.method.ConfidenceTestAssumptions;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.Pair;
import java.util.Arrays;
import java.util.Collection;

@ConfidenceTestAssumptions(name="One-Way Analysis of Variance", alsoKnownAs={"1-way ANOVA", "Fixed-effects 1-way ANOVA", "F test"}, description={"ANOVA tests to determine if the means between the various treatments are equal.", "ANOVA is a generalization of the paired Student t-test, where there can be multiple treatments.", "When there are two groups, a control group and a treatment group, ANOVA is equivalent to the unpaired t-test."}, assumptions={"The data are sampled from a Gaussian distribution.", "The variance within the different groups is equal.", "The data from each group is collected independently of each other."}, nullHypothesis="The means from all groups are equal.", dataPaired=false, dataSameSize=false, distribution=SnedecorFDistribution.CDF.class, reference={@PublicationReference(author={"Wikipedia"}, title="Analysis of Variance", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Analysis_of_variance")})
public class AnalysisOfVarianceOneWay
extends AbstractCloneableSerializable
implements BlockExperimentComparison<Number> {
    public static final AnalysisOfVarianceOneWay INSTANCE = new AnalysisOfVarianceOneWay();

    @PublicationReference(author={"Frederick J. Gravetter", "Larry B. Wallnau"}, title="Statistics for the Behavioral Sciences", type=PublicationType.Book, year=2003, pages={406, 412}, notes={"Chapter 13.3"})
    public Statistic evaluateNullHypothesis(Collection<? extends Collection<? extends Number>> data) {
        int k = data.size();
        int N = 0;
        double G = 0.0;
        double Sxx = 0.0;
        double SSwithin = 0.0;
        double SSbetween = 0.0;
        for (Collection<? extends Number> collection : data) {
            int n = collection.size();
            Pair<Double, Double> result = UnivariateStatisticsUtil.computeMeanAndVariance(collection);
            double SS = result.getSecond() * (double)(n - 1);
            SSwithin += SS;
            double T = result.getFirst() * (double)n;
            SSbetween += T * T / (double)n;
            N += n;
            for (Number number : collection) {
                double x = number.doubleValue();
                G += x;
                Sxx += x * x;
            }
        }
        int dfbetween = k - 1;
        int n = N - k;
        double MSbetween = (SSbetween -= G * G / (double)N) / (double)dfbetween;
        double MSwithin = SSwithin / (double)n;
        double F = MSbetween / MSwithin;
        return new Statistic(F, dfbetween, n);
    }

    public Statistic evaluateNullHypothesis(Collection<? extends Number> data1, Collection<? extends Number> data2) {
        return this.evaluateNullHypothesis(Arrays.asList(data1, data2));
    }

    public static class Statistic
    extends AbstractConfidenceStatistic {
        private double F;
        private double DFbetween;
        private double DFwithin;

        public Statistic(double F, double DFbetween, double DFwithin) {
            super(1.0 - SnedecorFDistribution.CDF.evaluate(F, DFbetween, DFwithin));
            this.setF(F);
            this.setDFbetween(DFbetween);
            this.setDFwithin(DFwithin);
        }

        @Override
        public Statistic clone() {
            return (Statistic)super.clone();
        }

        public double getF() {
            return this.F;
        }

        protected void setF(double F) {
            this.F = F;
        }

        public double getDFbetween() {
            return this.DFbetween;
        }

        protected void setDFbetween(double DFbetween) {
            this.DFbetween = DFbetween;
        }

        public double getDFwithin() {
            return this.DFwithin;
        }

        protected void setDFwithin(double DFwithin) {
            this.DFwithin = DFwithin;
        }

        @Override
        public double getTestStatistic() {
            return this.getF();
        }
    }
}

