/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.statistics.AbstractClosedFormSmoothUnivariateDistribution;
import gov.sandia.cognition.statistics.method.AbstractPairwiseMultipleHypothesisComparison;
import gov.sandia.cognition.statistics.method.AdjustedPValueStatistic;
import gov.sandia.cognition.statistics.method.ConfidenceTestAssumptions;
import gov.sandia.cognition.statistics.method.NullHypothesisEvaluator;
import java.util.Collection;

@ConfidenceTestAssumptions(name="Bonferroni correction", alsoKnownAs={"Bonferroni-Dunn test"}, description={"Bonferroni's correction is a conservative way to compensate for pair-wise null-hypothesis comparisons applied to multiple comparison to control false-discovery rate.", "The correction is known to be overly conservative, trading low false-discovery for high false-negative rates."}, assumptions={"The assumptions of the underlying pair-wise test are met."}, nullHypothesis="Each treatment has no effect on the measurements of the subjects", dataPaired=true, dataSameSize=true, distribution=AbstractClosedFormSmoothUnivariateDistribution.class, reference={@PublicationReference(author={"Janez Demsar"}, title="Statistical Comparisons of Classifiers over Multiple Data Sets", type=PublicationType.Journal, publication="Journal of Machine Learning Research", year=2006, url="http://www.jmlr.org/papers/volume7/demsar06a/demsar06a.pdf"), @PublicationReference(author={"Wikipedia"}, title="Bonferroni Correction", type=PublicationType.WebPage, year=2011, url="http://en.wikipedia.org/wiki/Bonferroni_correction")})
public class BonferroniCorrection
extends AbstractPairwiseMultipleHypothesisComparison<AdjustedPValueStatistic> {
    public BonferroniCorrection() {
        this(DEFAULT_PAIRWISE_TEST);
    }

    public BonferroniCorrection(NullHypothesisEvaluator<Collection<? extends Number>> pairwiseTest) {
        super(pairwiseTest);
    }

    @Override
    public BonferroniCorrection clone() {
        return (BonferroniCorrection)super.clone();
    }

    @Override
    public AdjustedPValueStatistic evaluateNullHypotheses(Collection<? extends Collection<? extends Number>> data, double uncompensatedAlpha) {
        int K = data.size();
        int N = K * (K - 1) / 2;
        double adjustedAlpha = BonferroniCorrection.adjust(uncompensatedAlpha, N);
        return new AdjustedPValueStatistic(data, uncompensatedAlpha, adjustedAlpha, this.getPairwiseTest());
    }

    public static double adjust(double uncompensatedAlpha, int numComparisons) {
        return uncompensatedAlpha / (double)numComparisons;
    }
}

