/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.math.UnivariateStatisticsUtil;
import gov.sandia.cognition.statistics.method.ConfidenceInterval;
import gov.sandia.cognition.statistics.method.ConfidenceIntervalEvaluator;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.Pair;
import java.util.Collection;

public class ChebyshevInequality
extends AbstractCloneableSerializable
implements ConfidenceIntervalEvaluator<Collection<Double>> {
    public static final ChebyshevInequality INSTANCE = new ChebyshevInequality();

    @Override
    public ConfidenceInterval computeConfidenceInterval(Collection<Double> data, double confidence) {
        Pair<Double, Double> result = UnivariateStatisticsUtil.computeMeanAndVariance(data);
        double mean = result.getFirst();
        double variance = result.getSecond();
        return this.computeConfidenceInterval(mean, variance, data.size(), confidence);
    }

    @Override
    public ConfidenceInterval computeConfidenceInterval(double sampleMean, double sampleVariance, int numSamples, double confidence) {
        if (confidence <= 0.0 || confidence > 1.0) {
            throw new IllegalArgumentException("Confidence must be 0 < confidence <= 1");
        }
        double a = confidence < 1.0 ? Math.sqrt(sampleVariance / (1.0 - confidence)) : Double.POSITIVE_INFINITY;
        return new ConfidenceInterval(sampleMean, sampleMean - a, sampleMean + a, confidence, numSamples);
    }
}

