/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.statistics.method.ConfidenceInterval;
import gov.sandia.cognition.statistics.method.ConfidenceIntervalEvaluator;
import gov.sandia.cognition.util.ObjectUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public class FieldConfidenceInterval
extends ConfidenceInterval {
    private Field field;

    public FieldConfidenceInterval(Field field, ConfidenceInterval confidenceInterval) {
        super(confidenceInterval);
        this.setField(field);
    }

    public boolean isMatch(Field field) {
        return this.isMatch(field.getName());
    }

    public boolean isMatch(String fieldName) {
        return this.getField().getName().equals(fieldName);
    }

    public boolean withinInterval(Object o) {
        boolean retval;
        try {
            this.getField().setAccessible(true);
            double value = this.getField().getDouble(o);
            retval = this.withinInterval(value);
        }
        catch (Exception e) {
            retval = false;
        }
        return retval;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    @Override
    public String toString() {
        return "Field: " + this.getField().getName() + ", Interval: " + super.toString();
    }

    public static <DataType> ArrayList<FieldConfidenceInterval> computeConfidenceInterval(Collection<DataType> data, ConfidenceIntervalEvaluator<Collection<? extends Number>> confidenceIntervalEvaluator, double confidence) {
        Class<?> dataClass = data.iterator().next().getClass();
        LinkedList<Field> allFields = ObjectUtil.getAllFields(dataClass);
        ArrayList<Field> interestedFields = new ArrayList<Field>(allFields.size());
        for (Field f : allFields) {
            Class<?> c = f.getType();
            if (!c.isPrimitive() && !Number.class.isAssignableFrom(c)) continue;
            interestedFields.add(f);
        }
        return FieldConfidenceInterval.computeConfidenceInterval(data, interestedFields, confidenceIntervalEvaluator, confidence);
    }

    public static <DataType> ArrayList<FieldConfidenceInterval> computeConfidenceInterval(Collection<DataType> data, ArrayList<Field> interestedFields, ConfidenceIntervalEvaluator<Collection<? extends Number>> confidenceIntervalEvaluator, double confidence) {
        Class<?> dataClass = null;
        for (DataType o : data) {
            if (dataClass == null) {
                dataClass = o.getClass();
            }
            if (dataClass.isInstance(o)) continue;
            throw new IllegalArgumentException("All classes in data must be EXACT same type");
        }
        int numFields = interestedFields.size();
        ArrayList fieldValues = new ArrayList(numFields);
        for (int i = 0; i < numFields; ++i) {
            fieldValues.add(new ArrayList(data.size()));
        }
        for (DataType o : data) {
            ArrayList<Object> values = ObjectUtil.getFieldValues(o, interestedFields);
            for (int i = 0; i < numFields; ++i) {
                ((ArrayList)fieldValues.get(i)).add(((Number)values.get(i)).doubleValue());
            }
        }
        ArrayList<FieldConfidenceInterval> confidenceIntervals = new ArrayList<FieldConfidenceInterval>(numFields);
        for (int i = 0; i < numFields; ++i) {
            FieldConfidenceInterval fci = new FieldConfidenceInterval(interestedFields.get(i), confidenceIntervalEvaluator.computeConfidenceInterval((Collection<? extends Number>)fieldValues.get(i), confidence));
            confidenceIntervals.add(fci);
        }
        return confidenceIntervals;
    }
}

