/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.UnivariateStatisticsUtil;
import gov.sandia.cognition.statistics.UnivariateDistribution;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;
import gov.sandia.cognition.statistics.method.AbstractConfidenceStatistic;
import gov.sandia.cognition.statistics.method.ConfidenceInterval;
import gov.sandia.cognition.statistics.method.ConfidenceIntervalEvaluator;
import gov.sandia.cognition.statistics.method.ConfidenceTestAssumptions;
import gov.sandia.cognition.statistics.method.NullHypothesisEvaluator;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.Pair;
import java.util.Collection;

@ConfidenceTestAssumptions(name="Gaussian Z-test", alsoKnownAs={"Z-test"}, description={"Determines if two populations have the same mean, if the populations are Gaussian and relatively large, at least 30 or so."}, assumptions={"The two groups are sampled independently of each other.", "The two groups are sampled from a Gaussian distribution, or the underlying distributions are non-Gaussian but obey the weak law of large numbers.", "The variances of the two groups are equal."}, nullHypothesis="The means of the groups are equal.", dataPaired=false, dataSameSize=false, distribution=UnivariateGaussian.CDF.class, reference={@PublicationReference(author={"Wikipedia"}, title="Z-test", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Z-test")})
public class GaussianConfidence
extends AbstractCloneableSerializable
implements NullHypothesisEvaluator<Collection<? extends Number>>,
ConfidenceIntervalEvaluator<Collection<? extends Number>> {
    public static final GaussianConfidence INSTANCE = new GaussianConfidence();

    public Statistic evaluateNullHypothesis(Collection<? extends Number> data1, Collection<? extends Number> data2) {
        int N1 = data1.size();
        UnivariateGaussian.PDF g1 = UnivariateGaussian.MaximumLikelihoodEstimator.learn(data1, 0.0);
        double std1 = Math.sqrt(g1.getVariance());
        int N2 = data2.size();
        UnivariateGaussian.PDF g2 = UnivariateGaussian.MaximumLikelihoodEstimator.learn(data2, 0.0);
        double std2 = Math.sqrt(g2.getVariance());
        double numerator = Math.abs(((UnivariateGaussian)g1).getMean() - ((UnivariateGaussian)g2).getMean());
        double denominator = Math.sqrt(std1 * std1 / (double)N1 + std2 * std2 / (double)N2);
        double z = numerator / denominator;
        return new Statistic(z);
    }

    public static Statistic evaluateNullHypothesis(Collection<? extends Double> data1, double data2) {
        Pair<Double, Double> result = UnivariateStatisticsUtil.computeMeanAndVariance(data1);
        double mean = result.getFirst();
        double variance = result.getSecond();
        double delta = Math.abs(mean - data2);
        double z = variance != 0.0 ? delta / Math.sqrt(variance) : (delta != 0.0 ? Double.POSITIVE_INFINITY : 0.0);
        System.out.println("Z = " + z);
        return new Statistic(z);
    }

    @Override
    public ConfidenceInterval computeConfidenceInterval(Collection<? extends Number> data, double confidence) {
        UnivariateGaussian.PDF g = UnivariateGaussian.MaximumLikelihoodEstimator.learn(data, 1.0E-5);
        return GaussianConfidence.computeConfidenceInterval(g, data.size(), confidence);
    }

    public static ConfidenceInterval computeConfidenceInterval(UnivariateDistribution<?> dataDistribution, int numSamples, double confidence) {
        return INSTANCE.computeConfidenceInterval(((Number)dataDistribution.getMean()).doubleValue(), dataDistribution.getVariance(), numSamples, confidence);
    }

    @Override
    @PublicationReference(author={"Wikipedia"}, title="Standard error (statistics)", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Standard_error_(statistics)")
    public ConfidenceInterval computeConfidenceInterval(double mean, double variance, int numSamples, double confidence) {
        double alpha = 1.0 - confidence;
        double z = -UnivariateGaussian.CDF.Inverse.evaluate(0.5 * alpha, 0.0, 1.0);
        double delta = z * Math.sqrt(variance / (double)numSamples);
        return new ConfidenceInterval(mean, mean - delta, mean + delta, confidence, numSamples);
    }

    public static class Statistic
    extends AbstractConfidenceStatistic {
        private double z;

        public Statistic(double z) {
            super(2.0 * UnivariateGaussian.CDF.evaluate(-z, 0.0, 1.0));
            this.setZ(z);
        }

        public double getZ() {
            return this.z;
        }

        protected void setZ(double z) {
            this.z = z;
        }

        @Override
        public double getTestStatistic() {
            return this.getZ();
        }
    }
}

