/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.statistics.method.AbstractPairwiseMultipleHypothesisComparison;
import gov.sandia.cognition.statistics.method.NullHypothesisEvaluator;
import gov.sandia.cognition.statistics.method.SidakCorrection;
import gov.sandia.cognition.util.ArrayIndexSorter;
import java.util.Collection;

@PublicationReference(author={"Wikipedia"}, title="Holm\u2013Bonferroni method", type=PublicationType.WebPage, url="http://en.wikipedia.org/wiki/Holm%E2%80%93Bonferroni_method", year=2011)
public class HolmCorrection
extends AbstractPairwiseMultipleHypothesisComparison<Statistic> {
    public HolmCorrection() {
        this(DEFAULT_PAIRWISE_TEST);
    }

    public HolmCorrection(NullHypothesisEvaluator<Collection<? extends Number>> pairwiseTest) {
        super(pairwiseTest);
    }

    @Override
    public HolmCorrection clone() {
        return (HolmCorrection)super.clone();
    }

    @Override
    public Statistic evaluateNullHypotheses(Collection<? extends Collection<? extends Number>> data, double uncompensatedAlpha) {
        return new Statistic(data, uncompensatedAlpha, this.getPairwiseTest());
    }

    public static class Statistic
    extends AbstractPairwiseMultipleHypothesisComparison.Statistic {
        protected Matrix adjustedAlphas;

        public Statistic(Collection<? extends Collection<? extends Number>> data, double uncompensatedAlpha, NullHypothesisEvaluator<Collection<? extends Number>> pairwiseTest) {
            super(data, uncompensatedAlpha, pairwiseTest);
            int numComparisons = this.treatmentCount * (this.treatmentCount - 1) / 2;
            this.computePairwiseTestResults(data, pairwiseTest);
            double[] pvalues = new double[numComparisons];
            int index = 0;
            for (int i = 0; i < this.treatmentCount; ++i) {
                for (int j = i + 1; j < this.treatmentCount; ++j) {
                    pvalues[index] = this.nullHypothesisProbabilities.getElement(i, j);
                    ++index;
                }
            }
            int[] sortedIndices = ArrayIndexSorter.sortArrayAscending(pvalues);
            double[] adjustedAlpha = new double[numComparisons];
            int hypothesesRemaining = numComparisons;
            for (int i = 0; i < numComparisons; ++i) {
                adjustedAlpha[sortedIndices[i]] = SidakCorrection.adjust(this.uncompensatedAlpha, hypothesesRemaining);
                --hypothesesRemaining;
            }
            Matrix alphaMatrix = MatrixFactory.getDefault().createMatrix(this.treatmentCount, this.treatmentCount);
            index = 0;
            for (int i = 0; i < this.treatmentCount; ++i) {
                for (int j = i + 1; j < this.treatmentCount; ++j) {
                    alphaMatrix.setElement(i, j, adjustedAlpha[index]);
                    alphaMatrix.setElement(j, i, adjustedAlpha[index]);
                    ++index;
                }
            }
            this.adjustedAlphas = alphaMatrix;
        }

        @Override
        public double getAdjustedAlpha(int i, int j) {
            return this.adjustedAlphas.getElement(i, j);
        }
    }
}

