/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.statistics.ProbabilityDensityFunction;
import gov.sandia.cognition.util.DefaultWeightedValue;
import java.util.ArrayList;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Importance Sampling", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Importance_sampling")
public class ImportanceSampling {
    public static <ValueType> ArrayList<DefaultWeightedValue<ValueType>> sample(ProbabilityDensityFunction<ValueType> importanceDistribution, Evaluator<ValueType, Double> targetDistribution, Random random, int numSamples) {
        ArrayList importanceSamples = importanceDistribution.sample(random, numSamples);
        ArrayList<DefaultWeightedValue<ValueType>> weightedSamples = new ArrayList<DefaultWeightedValue<ValueType>>(numSamples);
        for (Object importanceSample : importanceSamples) {
            double numerator = targetDistribution.evaluate(importanceSample);
            double denominator = (Double)importanceDistribution.evaluate(importanceSample);
            double weight = denominator != 0.0 ? numerator / denominator : 0.0;
            weightedSamples.add(new DefaultWeightedValue(importanceSample, weight));
        }
        return weightedSamples;
    }
}

