/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.root.RootFinder;
import gov.sandia.cognition.learning.algorithm.root.RootFinderRiddersMethod;
import gov.sandia.cognition.learning.algorithm.root.SolverFunction;
import gov.sandia.cognition.learning.data.DefaultInputOutputPair;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.math.ProbabilityUtil;
import gov.sandia.cognition.statistics.CumulativeDistributionFunction;
import gov.sandia.cognition.statistics.DiscreteDistribution;
import gov.sandia.cognition.statistics.ProbabilityMassFunctionUtil;
import gov.sandia.cognition.statistics.SmoothCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.SmoothUnivariateDistribution;
import gov.sandia.cognition.statistics.UnivariateProbabilityDensityFunction;
import java.util.ArrayList;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Inverse transform sampling", type=PublicationType.WebPage, year=2008, url="http://en.wikipedia.org/wiki/Inverse_transform_sampling")
public class InverseTransformSampling {
    public static final RootFinder DEFAULT_ROOT_FINDER = new RootFinderRiddersMethod();
    public static final double DEFAULT_TOLERANCE = 1.0E-10;
    public static int FUNCTION_EVALUATIONS;

    public static ArrayList<Double> sample(CumulativeDistributionFunction<Double> cdf, Random random, int numSamples) {
        ArrayList<Double> samples = new ArrayList<Double>(numSamples);
        for (int n = 0; n < numSamples; ++n) {
            double p = random.nextDouble();
            InputOutputPair<Double, Double> result = InverseTransformSampling.inverse(cdf, p);
            if (Math.abs(result.getOutput() - p) > 1.0E-10) {
                throw new IllegalArgumentException("Could not invert the CDF (" + cdf + ") at p = " + p + "(" + result.getOutput() + ")");
            }
            samples.add(result.getInput());
        }
        return samples;
    }

    public static <NumberType extends Number> InputOutputPair<NumberType, Double> inverse(CumulativeDistributionFunction<NumberType> cdf, double p) {
        if (cdf instanceof DiscreteDistribution) {
            return ProbabilityMassFunctionUtil.inverse(cdf, p);
        }
        if (cdf instanceof SmoothUnivariateDistribution) {
            return InverseTransformSampling.inverseNewtonsMethod((SmoothUnivariateDistribution)((Object)cdf), p, 1.0E-10);
        }
        return InverseTransformSampling.inverseRootFinder(DEFAULT_ROOT_FINDER, cdf, p);
    }

    public static InputOutputPair<Double, Double> inverseRootFinder(RootFinder rootFinder, CumulativeDistributionFunction<Double> cdf, double p) {
        ProbabilityUtil.assertIsProbability(p);
        rootFinder.setTolerance(1.0E-10);
        double mean = (Double)cdf.getMean();
        double stddev = Math.sqrt(cdf.getVariance());
        double maxDev = 10.0;
        if (stddev > 10.0 || Double.isInfinite(stddev)) {
            stddev = 10.0;
        }
        double delta = stddev * 2.0 * (p - 0.5);
        double xhat = mean + delta;
        SolverFunction fhat = new SolverFunction(p, cdf);
        rootFinder.setInitialGuess(xhat);
        InputOutputPair root = (InputOutputPair)rootFinder.learn(fhat);
        return DefaultInputOutputPair.create(root.getInput(), (Double)root.getOutput() + p);
    }

    public static InputOutputPair<Double, Double> inverseNewtonsMethod(SmoothUnivariateDistribution distribution, double p, double tolerance) {
        ProbabilityUtil.assertIsProbability(p);
        SmoothCumulativeDistributionFunction cdf = distribution.getCDF();
        InputOutputPair<Double, Double> initialGuess = InverseTransformSampling.initializeNewtonsMethod(cdf, p, tolerance);
        double xhat = initialGuess.getInput();
        Object phat = initialGuess.getOutput();
        if (Math.abs(p - phat) <= tolerance) {
            return initialGuess;
        }
        double xmin = (Double)cdf.getMinSupport();
        double xmax = (Double)cdf.getMaxSupport();
        UnivariateProbabilityDensityFunction pdf = distribution.getProbabilityFunction();
        double err = p - phat;
        Object m = pdf.evaluate(xhat);
        double stepScale = 0.5;
        double stepMultiplier = 1.0;
        double maxStep = Math.min((xmax - xmin) / 2.0, 1000.0 * cdf.getVariance());
        for (int iteration = 0; iteration < 100; ++iteration) {
            double xproposed;
            if (Math.abs(m) <= Double.MIN_VALUE) {
                xproposed = xhat + err * stepMultiplier;
            } else {
                double step = -(phat - p) * stepMultiplier / m;
                if (Math.abs(step) > maxStep) {
                    step = stepMultiplier * Math.signum(step) * maxStep;
                }
                xproposed = xhat + step;
            }
            if (xproposed <= xmin) {
                stepMultiplier *= 0.5;
            } else if (xproposed >= xmax) {
                stepMultiplier *= 0.5;
            } else {
                Object pproposed = cdf.evaluate(xproposed);
                double errproposed = p - pproposed;
                if (Math.abs(errproposed) <= Math.abs(err)) {
                    stepMultiplier = 1.0;
                    xhat = xproposed;
                    phat = pproposed;
                    m = pdf.evaluate(xhat);
                    err = errproposed;
                } else {
                    stepMultiplier *= 0.5;
                }
            }
            if (Math.abs(err) <= tolerance) break;
        }
        return new DefaultInputOutputPair<Double, Double>(xhat, (Double)phat);
    }

    protected static InputOutputPair<Double, Double> initializeNewtonsMethod(SmoothCumulativeDistributionFunction cdf, double p, double tolerance) {
        Object phat;
        double xhat;
        double xmin = (Double)cdf.getMinSupport();
        double xmax = (Double)cdf.getMaxSupport();
        if (Math.abs(p) <= tolerance) {
            xhat = xmin;
            phat = cdf.evaluate(xhat);
        } else if (p == 1.0) {
            xhat = xmax;
            phat = cdf.evaluate(xhat);
        } else {
            double mean = (Double)cdf.getMean();
            Object pmean = cdf.evaluate(mean);
            xhat = mean;
            phat = pmean;
            if (Math.abs(p - pmean) <= tolerance) {
                xhat = mean;
                phat = pmean;
            } else if (p < pmean) {
                double leftFraction = p / pmean;
                double leftSegment = mean - xmin;
                xhat = leftFraction * leftSegment;
                phat = cdf.evaluate(xhat);
                if (Math.abs(phat) <= tolerance) {
                    xhat = mean;
                    phat = pmean;
                }
            } else {
                double rightFraction = (p - pmean) / (1.0 - pmean);
                double rightSegment = xmax - mean;
                xhat = rightFraction * rightSegment + mean;
                phat = cdf.evaluate(xhat);
                if (Math.abs(1.0 - phat) <= tolerance) {
                    xhat = mean;
                    phat = pmean;
                }
            }
            if (Double.isInfinite(xhat)) {
                xhat = mean;
                phat = pmean;
            }
        }
        return new DefaultInputOutputPair<Double, Double>(xhat, Double.valueOf(phat));
    }
}

