/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.data.DatasetUtil;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;
import gov.sandia.cognition.statistics.method.AbstractConfidenceStatistic;
import gov.sandia.cognition.statistics.method.ConfidenceTestAssumptions;
import gov.sandia.cognition.statistics.method.NullHypothesisEvaluator;
import gov.sandia.cognition.statistics.method.WilcoxonSignedRankConfidence;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.DefaultPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

@ConfidenceTestAssumptions(name="Mann-Whitney U-test", alsoKnownAs={"Mann-Whitney-Wolcoxon", "Wilcoxon rank-sum test", "Wilcoxon-Mann-Whitney test", "U-test"}, description={"A nonparameteric test to determine is two groups of data were drawn from the same underlying distribution."}, assumptions={"The groups were sampled independently.", "The data are orginal and we can determine which of two samples is greater than the other.", "Although the two populations don't have to follow any particular distribution, the two distributions must have a similar shape."}, nullHypothesis="The data were drawn from the same distribution.", dataPaired=false, dataSameSize=false, distribution=UnivariateGaussian.CDF.class, reference={@PublicationReference(author={"Wikipedia"}, title="Mann-Whitney U", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Mann-Whitney_U")})
public class MannWhitneyUConfidence
extends AbstractCloneableSerializable
implements NullHypothesisEvaluator<Collection<? extends Number>> {
    public Statistic evaluateNullHypothesis(Collection<? extends InputOutputPair<? extends Number, Boolean>> scoreClassPairs) {
        DefaultPair pair = DatasetUtil.splitDatasets(scoreClassPairs);
        LinkedList data1 = pair.getFirst();
        LinkedList data2 = pair.getSecond();
        return this.evaluateNullHypothesis(data1, data2);
    }

    public Statistic evaluateNullHypothesis(Collection<? extends Number> data1, Collection<? extends Number> data2) {
        int N1 = data1.size();
        int N2 = data2.size();
        ArrayList<Number> allData = new ArrayList<Number>(N1 + N2);
        allData.addAll(data1);
        allData.addAll(data2);
        double[] ranks = WilcoxonSignedRankConfidence.ranks(allData);
        double sum1 = 0.0;
        for (int i = 0; i < N1; ++i) {
            sum1 += ranks[i];
        }
        double sum2 = 0.0;
        for (int i = N1; i < N1 + N2; ++i) {
            sum2 += ranks[i];
        }
        return new Statistic(sum1, N1, sum2, N2);
    }

    public static class Statistic
    extends AbstractConfidenceStatistic {
        private double U;
        private double z;
        private int N1;
        private int N2;

        public Statistic(double sum1, int N1, double sum2, int N2) {
            this(Statistic.computeU(sum1, N1, sum2, N2), N1, N2);
        }

        private Statistic(double U, int N1, int N2) {
            this(U, N1, N2, Statistic.computeZ(U, N1, N2));
        }

        private Statistic(double U, int N1, int N2, double z) {
            super(Statistic.computeNullHypothesisProbability(z));
            this.setU(U);
            this.setN1(N1);
            this.setN2(N2);
            this.setZ(z);
        }

        public Statistic(Statistic other) {
            this(other.getU(), other.getN1(), other.getN2());
        }

        public static double computeU(double sum1, int N1, double sum2, int N2) {
            double U1 = sum1 - (double)(N1 * (N1 + 1)) / 2.0;
            double U2 = sum2 - (double)(N2 * (N2 + 1)) / 2.0;
            return Math.min(U1, U2);
        }

        public static double computeZ(double U, int N1, int N2) {
            double m = (double)(N1 * N2) / 2.0;
            double stddev = Math.sqrt((double)N1 * (double)N2 * (double)(N1 + N2 + 1) / 12.0);
            double z = stddev > 0.0 ? (U - m) / stddev : 100.0;
            return z;
        }

        public static double computeNullHypothesisProbability(double z) {
            return 2.0 * UnivariateGaussian.CDF.evaluate(-Math.abs(z), 0.0, 1.0);
        }

        public double getU() {
            return this.U;
        }

        protected void setU(double U) {
            this.U = U;
        }

        public double getZ() {
            return this.z;
        }

        protected void setZ(double z) {
            this.z = z;
        }

        public int getN1() {
            return this.N1;
        }

        protected void setN1(int N1) {
            this.N1 = N1;
        }

        public int getN2() {
            return this.N2;
        }

        protected void setN2(int N2) {
            this.N2 = N2;
        }

        @Override
        public double getTestStatistic() {
            return this.getZ();
        }
    }
}

